/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.util.Arrays;
import org.sing_group.seda.bio.SequenceType;
import org.sing_group.seda.bio.consensus.ConsensusBaseStrategy;
import org.sing_group.seda.bio.consensus.SequencesGroupConsensusFactory;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequenceBuilder;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupBuilder;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class GenerateConsensusSequencesGroupTransformation
implements SequencesGroupTransformation {
    private final SequencesGroupBuilder builder = factory::newSequencesGroup;
    private final SequenceBuilder sequenceBuilder = factory::newSequence;
    private SequenceType sequenceType;
    private ConsensusBaseStrategy consensusBaseStrategy;
    private double minimumPresence;
    private boolean verbose;

    public GenerateConsensusSequencesGroupTransformation(SequenceType sequenceType, ConsensusBaseStrategy consensusBaseStrategy, double minimumPresence, boolean verbose) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), sequenceType, consensusBaseStrategy, minimumPresence, verbose);
    }

    public GenerateConsensusSequencesGroupTransformation(DatatypeFactory factory, SequenceType sequenceType, ConsensusBaseStrategy consensusBaseStrategy, double minimumPresence, boolean verbose) {
        this.sequenceType = sequenceType;
        this.consensusBaseStrategy = consensusBaseStrategy;
        this.minimumPresence = minimumPresence;
        this.verbose = verbose;
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        Sequence consensus = SequencesGroupConsensusFactory.getConsensusCreator(this.sequenceType, this.consensusBaseStrategy, this.sequenceBuilder, this.minimumPresence, this.verbose).getConsensus(sequencesGroup);
        return this.builder.of("consensus_" + sequencesGroup.getName(), sequencesGroup.getProperties(), Arrays.asList(consensus));
    }
}

