/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.ncbi;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.ncbi.NcbiTaxonomyConfiguration;
import org.sing_group.seda.core.ncbi.NcbiTaxonomyFields;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.rename.FileRenameConfiguration;
import org.sing_group.seda.datatype.rename.ReplaceCharacterConfiguration;
import org.sing_group.seda.datatype.rename.SequenceHeaderRenameConfiguration;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.MapRenameSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.NcbiRenameSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.ncbi.NcbiRenameTransformationChangeType;
import org.sing_group.seda.util.NetUtils;

@XmlRootElement
public class NcbiRenameTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private MapRenameSequencesGroupDatasetTransformation.RenameMode filePosition;
    @XmlElement
    private String fileDelimiter;
    @XmlElement
    private MapRenameSequencesGroupDatasetTransformation.RenameMode sequencePosition;
    @XmlElement
    private String sequenceDelimiter;
    @XmlElement
    private boolean sequenceAddIndex;
    @XmlElement
    private String sequenceIndexDelimiter;
    @XmlElement
    private boolean replaceBlankSpaces;
    @XmlElement
    private boolean replaceSpecialCharacters;
    @XmlElement
    private String replacementString;
    @XmlElement
    private boolean saveReplacementsMap;
    @XmlElement
    private File replacementsMapFile;
    @XmlElement
    private String ncbiTaxonomyDelimiter;
    @XmlElement
    private List<NcbiTaxonomyFields> ncbiTaxonomyFields;

    public NcbiRenameTransformationProvider() {
    }

    public NcbiRenameTransformationProvider(MapRenameSequencesGroupDatasetTransformation.RenameMode filePosition, String fileDelimiter, MapRenameSequencesGroupDatasetTransformation.RenameMode sequencePosition, String sequenceDelimiter, boolean sequenceAddIndex, String sequenceIndexDelimiter, boolean replaceBlankSpaces, boolean replaceSpecialCharacters, String replacementString, boolean saveReplacementsMap, File replacementsMapFile, String ncbiTaxonomyDelimiter, List<NcbiTaxonomyFields> ncbiTaxonomyFields) {
        this.filePosition = filePosition;
        this.fileDelimiter = fileDelimiter;
        this.sequencePosition = sequencePosition;
        this.sequenceDelimiter = sequenceDelimiter;
        this.sequenceAddIndex = sequenceAddIndex;
        this.sequenceIndexDelimiter = sequenceIndexDelimiter;
        this.replaceBlankSpaces = replaceBlankSpaces;
        this.replaceSpecialCharacters = replaceSpecialCharacters;
        this.replacementString = replacementString;
        this.saveReplacementsMap = saveReplacementsMap;
        this.replacementsMapFile = replacementsMapFile;
        this.ncbiTaxonomyDelimiter = ncbiTaxonomyDelimiter;
        this.ncbiTaxonomyFields = ncbiTaxonomyFields;
    }

    public void setFileDelimiter(String fileDelimiter) {
        if (this.fileDelimiter == null || !this.fileDelimiter.equals(fileDelimiter)) {
            this.fileDelimiter = fileDelimiter;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.FILE_DELIMITER, this.fileDelimiter);
        }
    }

    public String getFileDelimiter() {
        return this.fileDelimiter;
    }

    public void setFilePosition(MapRenameSequencesGroupDatasetTransformation.RenameMode filePosition) {
        if (this.filePosition == null || !this.filePosition.equals((Object)filePosition)) {
            this.filePosition = filePosition;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.FILE_POSITION, (Object)this.filePosition);
        }
    }

    public MapRenameSequencesGroupDatasetTransformation.RenameMode getFilePosition() {
        return this.filePosition;
    }

    public void setSequenceAddIndex(boolean sequenceAddIndex) {
        if (this.sequenceAddIndex != sequenceAddIndex) {
            this.sequenceAddIndex = sequenceAddIndex;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.SEQUENCE_ADD_INDEX, this.sequenceAddIndex);
        }
    }

    public boolean isSequenceAddIndex() {
        return this.sequenceAddIndex;
    }

    public void setSequenceDelimiter(String sequenceDelimiter) {
        if (this.sequenceDelimiter == null || !this.sequenceDelimiter.equals(sequenceDelimiter)) {
            this.sequenceDelimiter = sequenceDelimiter;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.SEQUENCE_DELIMITER, this.sequenceDelimiter);
        }
    }

    public String getSequenceDelimiter() {
        return this.sequenceDelimiter;
    }

    public void setSequenceIndexDelimiter(String sequenceIndexDelimiter) {
        if (this.sequenceIndexDelimiter == null || !this.sequenceIndexDelimiter.equals(sequenceIndexDelimiter)) {
            this.sequenceIndexDelimiter = sequenceIndexDelimiter;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.SEQUENCE_INDEX_DELIMITER, this.sequenceIndexDelimiter);
        }
    }

    public String getSequenceIndexDelimiter() {
        return this.sequenceIndexDelimiter;
    }

    public void setSequencePosition(MapRenameSequencesGroupDatasetTransformation.RenameMode sequencePosition) {
        if (this.sequencePosition == null || !this.sequencePosition.equals((Object)sequencePosition)) {
            this.sequencePosition = sequencePosition;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.SEQUENCE_POSITION, (Object)this.sequencePosition);
        }
    }

    public MapRenameSequencesGroupDatasetTransformation.RenameMode getSequencePosition() {
        return this.sequencePosition;
    }

    public void setReplaceBlankSpaces(boolean replaceBlankSpaces) {
        if (this.replaceBlankSpaces != replaceBlankSpaces) {
            this.replaceBlankSpaces = replaceBlankSpaces;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.REPLACE_BLANK_SPACES, this.replaceBlankSpaces);
        }
    }

    public boolean isReplaceBlankSpaces() {
        return this.replaceBlankSpaces;
    }

    public void setReplaceSpecialCharacters(boolean replaceSpecialCharacters) {
        if (this.replaceSpecialCharacters != replaceSpecialCharacters) {
            this.replaceSpecialCharacters = replaceSpecialCharacters;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.REPLACE_SPECIAL_CHARACTERS, this.replaceSpecialCharacters);
        }
    }

    public boolean isReplaceSpecialCharacters() {
        return this.replaceSpecialCharacters;
    }

    public void setReplacementString(String replacementString) {
        if (this.replacementString == null || !this.replacementString.equals(replacementString)) {
            this.replacementString = replacementString;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.REPLACEMENT_STRING, this.replacementString);
        }
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public void clearReplacementsMapFile() {
        this.replacementsMapFile = null;
        this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.REPLACEMENTS_MAP_FILE, this.replacementsMapFile);
    }

    public void setReplacementsMapFile(File replacementsMapFile) {
        if (this.replacementsMapFile == null || !this.replacementsMapFile.equals(replacementsMapFile)) {
            this.replacementsMapFile = replacementsMapFile;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.REPLACEMENTS_MAP_FILE, this.replacementsMapFile);
        }
    }

    public File getReplacementsMapFile() {
        return this.replacementsMapFile;
    }

    public void setSaveReplacementsMap(boolean saveReplacementsMap) {
        if (this.saveReplacementsMap != saveReplacementsMap) {
            this.saveReplacementsMap = saveReplacementsMap;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.SAVE_REPLACEMENTS_MAP, this.isSaveReplacementsMap());
        }
    }

    public boolean isSaveReplacementsMap() {
        return this.saveReplacementsMap;
    }

    public void setNcbiTaxonomyDelimiter(String ncbiTaxonomyDelimiter) {
        if (this.ncbiTaxonomyDelimiter == null || !this.ncbiTaxonomyDelimiter.equals(ncbiTaxonomyDelimiter)) {
            this.ncbiTaxonomyDelimiter = ncbiTaxonomyDelimiter;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.NCBI_TAXONOMY_DELIMITER, this.ncbiTaxonomyDelimiter);
        }
    }

    public String getNcbiTaxonomyDelimiter() {
        return this.ncbiTaxonomyDelimiter;
    }

    public void setNcbiTaxonomyFields(List<NcbiTaxonomyFields> ncbiTaxonomyFields) {
        if (this.ncbiTaxonomyFields == null || !this.ncbiTaxonomyFields.equals(ncbiTaxonomyFields)) {
            this.ncbiTaxonomyFields = ncbiTaxonomyFields;
            this.fireTransformationsConfigurationModelEvent(NcbiRenameTransformationChangeType.NCBI_TAXONOMY_FIELDS, this.ncbiTaxonomyFields);
        }
    }

    public List<NcbiTaxonomyFields> getNcbiTaxonomyFields() {
        return this.ncbiTaxonomyFields;
    }

    @Override
    public Validation validate() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (!this.isNetAvailable()) {
            errorList.add("Net is not available");
        }
        if (this.filePosition == null) {
            errorList.add("File position is not set");
        }
        if (this.sequencePosition == null) {
            errorList.add("Sequence position is not set");
        }
        if (this.saveReplacementsMap && this.replacementsMapFile == null) {
            errorList.add("Replacements save map is active but file is not set");
        }
        if (errorList.isEmpty()) {
            return new DefaultValidation(new String[0]);
        }
        return new DefaultValidation(errorList);
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        if (this.isSaveReplacementsMap()) {
            return new NcbiRenameSequencesGroupDatasetTransformation(factory, this.getFileNameConfiguration(), this.getHeaderConfiguration(), this.getTaxonomyConfiguration(), this.getReplacementsMapFile());
        }
        return new NcbiRenameSequencesGroupDatasetTransformation(factory, this.getFileNameConfiguration(), this.getHeaderConfiguration(), this.getTaxonomyConfiguration());
    }

    private FileRenameConfiguration getFileNameConfiguration() {
        return new FileRenameConfiguration(this.getFilePosition(), this.getFileDelimiter(), this.getReplaceCharacterConfiguration());
    }

    private ReplaceCharacterConfiguration getReplaceCharacterConfiguration() {
        return new ReplaceCharacterConfiguration(this.isReplaceBlankSpaces(), this.isReplaceSpecialCharacters(), this.getReplacementString());
    }

    private SequenceHeaderRenameConfiguration getHeaderConfiguration() {
        return new SequenceHeaderRenameConfiguration(this.getSequencePosition(), this.getSequenceDelimiter(), this.isSequenceAddIndex(), this.getSequenceIndexDelimiter(), this.getReplaceCharacterConfiguration());
    }

    private NcbiTaxonomyConfiguration getTaxonomyConfiguration() {
        List<NcbiTaxonomyFields> fields = this.getNcbiTaxonomyFields();
        return new NcbiTaxonomyConfiguration(this.getNcbiTaxonomyDelimiter(), fields.toArray(new NcbiTaxonomyFields[fields.size()]));
    }

    private boolean isNetAvailable() {
        return NetUtils.isHostAvailable("https://www.ncbi.nlm.nih.gov".replace("https://", ""));
    }

    public Optional<String> getGenerateButtonTooltipMessage() {
        if (this.isNetAvailable()) {
            return Optional.empty();
        }
        return Optional.of("Can't connect to the NCBI service. Please, check your internet connection.");
    }
}

