/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.plugin.core.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.gui.configuration_panel.isoforms.RemoveIsoformsConfigurationPanel;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.core.info.plugin.RemoveIsoformsSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.isoforms.RemoveIsoformsTransformationProvider;

public class RemoveIsoformsSedaGuiPlugin
extends AbstractSedaGuiPlugin {
    private final RemoveIsoformsConfigurationPanel panel = new RemoveIsoformsConfigurationPanel();

    @Override
    public String getName() {
        return "Remove isoforms";
    }

    @Override
    public String getGroupName() {
        return RemoveIsoformsSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Keep the isoform with the size closest to that specified, and remove all other isoforms, identified based on a shared word of specified length.";
    }

    @Override
    public Component getEditor() {
        return this.panel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.panel.getTransformationProvider();
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<RemoveIsoformsTransformationProvider>().write(this.panel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.panel.setTransformationProvider((RemoveIsoformsTransformationProvider)new JsonObjectReader().read(file, RemoveIsoformsTransformationProvider.class));
    }
}

