/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.plugin.core.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.gui.configuration_panel.MergeConfigurationPanel;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.core.info.plugin.RegexSplitSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.merge.MergeTransformationProvider;

public class MergeGuiSedaPlugin
extends AbstractSedaGuiPlugin {
    private final MergeConfigurationPanel panel = new MergeConfigurationPanel();

    @Override
    public String getName() {
        return "Merge";
    }

    @Override
    public String getGroupName() {
        return RegexSplitSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Merge all input FASTA files into a single output FASTA.";
    }

    @Override
    public Component getEditor() {
        return this.panel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.panel.getTransformationProvider();
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<MergeTransformationProvider>().write(this.panel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.panel.setTransformationProvider((MergeTransformationProvider)new JsonObjectReader().read(file, MergeTransformationProvider.class));
    }
}

