/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.ncbi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.gui.configuration_panel.ncbi.FileRenameConfigurationPanel;
import org.sing_group.seda.gui.configuration_panel.ncbi.NcbiTaxonomyConfigurationPanel;
import org.sing_group.seda.gui.configuration_panel.ncbi.ReplaceOptionsConfigurationPanel;
import org.sing_group.seda.gui.configuration_panel.ncbi.SequenceHeaderRenameConfigurationPanel;
import org.sing_group.seda.transformation.provider.ncbi.NcbiRenameTransformationProvider;

public class NcbiRenameConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FileRenameConfigurationPanel fileRenamePanel;
    private SequenceHeaderRenameConfigurationPanel sequenceHeaderRenamePanel;
    private ReplaceOptionsConfigurationPanel replaceOptionsConfigurationPanel;
    private NcbiTaxonomyConfigurationPanel ncbiTaxonomyConfigurationPanel;
    private NcbiRenameTransformationProvider transformationProvider;

    public NcbiRenameConfigurationPanel() {
        this.init();
        this.transformationProvider = new NcbiRenameTransformationProvider(this.fileRenamePanel.getPosition(), this.fileRenamePanel.getDelimiter(), this.sequenceHeaderRenamePanel.getPosition(), this.sequenceHeaderRenamePanel.getDelimiter(), this.sequenceHeaderRenamePanel.isAddIndex(), this.sequenceHeaderRenamePanel.getIndexDelimiter(), this.replaceOptionsConfigurationPanel.isReplaceBlankSpaces(), this.replaceOptionsConfigurationPanel.isReplaceSpecialCharacters(), this.replaceOptionsConfigurationPanel.getReplacementString(), this.replaceOptionsConfigurationPanel.isSaveReplacementsMap(), this.replaceOptionsConfigurationPanel.getReplacementsMapFile(), this.ncbiTaxonomyConfigurationPanel.getDelimiter(), this.ncbiTaxonomyConfigurationPanel.getFields());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.getFileRenameConfigurationPanel());
        mainPanel.add(this.getSequenceHeaderRenameConfigurationPanel());
        mainPanel.add(this.getReplaceOptionsConfigurationPanel());
        mainPanel.add(this.getNcbiTaxonomyConfigurationPanel());
        return new CenteredJPanel((Component)mainPanel);
    }

    private Component getFileRenameConfigurationPanel() {
        this.fileRenamePanel = new FileRenameConfigurationPanel();
        this.fileRenamePanel.addPropertyChangeListener(this::fileRenamePropertyChanged);
        NcbiRenameConfigurationPanel.addTitledBorder(this.fileRenamePanel, "File name");
        return this.fileRenamePanel;
    }

    private void fileRenamePropertyChanged(PropertyChangeEvent event) {
        switch (event.getPropertyName()) {
            case "seda.filerenameconfiguration.position": {
                this.transformationProvider.setFilePosition(this.fileRenamePanel.getPosition());
                break;
            }
            case "seda.filerenameconfiguration.delimiter": {
                this.transformationProvider.setFileDelimiter(this.fileRenamePanel.getDelimiter());
            }
        }
    }

    private Component getSequenceHeaderRenameConfigurationPanel() {
        this.sequenceHeaderRenamePanel = new SequenceHeaderRenameConfigurationPanel();
        NcbiRenameConfigurationPanel.addTitledBorder(this.sequenceHeaderRenamePanel, "Sequence headers");
        this.sequenceHeaderRenamePanel.addPropertyChangeListener(this::sequenceHeaderRenamePropertyChanged);
        return this.sequenceHeaderRenamePanel;
    }

    private void sequenceHeaderRenamePropertyChanged(PropertyChangeEvent event) {
        switch (event.getPropertyName()) {
            case "seda.sequenceheaderrenameconfiguration.position": {
                this.transformationProvider.setSequencePosition(this.sequenceHeaderRenamePanel.getPosition());
                break;
            }
            case "seda.sequenceheaderconfiguration.delimiter": {
                this.transformationProvider.setSequenceDelimiter(this.sequenceHeaderRenamePanel.getDelimiter());
                break;
            }
            case "seda.sequenceheaderconfiguration.addindex": {
                this.transformationProvider.setSequenceAddIndex(this.sequenceHeaderRenamePanel.isAddIndex());
                break;
            }
            case "seda.sequenceheaderconfiguration.indexdelimiter": {
                this.transformationProvider.setSequenceIndexDelimiter(this.sequenceHeaderRenamePanel.getIndexDelimiter());
            }
        }
    }

    private Component getReplaceOptionsConfigurationPanel() {
        this.replaceOptionsConfigurationPanel = new ReplaceOptionsConfigurationPanel();
        NcbiRenameConfigurationPanel.addTitledBorder(this.replaceOptionsConfigurationPanel, "Configuration");
        this.replaceOptionsConfigurationPanel.addPropertyChangeListener(this::replaceOptionsConfigurationPropertyChanged);
        return this.replaceOptionsConfigurationPanel;
    }

    private void replaceOptionsConfigurationPropertyChanged(PropertyChangeEvent event) {
        switch (event.getPropertyName()) {
            case "seda.replaceoptionsconfiguration.replaceblankspaces": {
                this.transformationProvider.setReplaceBlankSpaces(this.replaceOptionsConfigurationPanel.isReplaceBlankSpaces());
                break;
            }
            case "seda.replaceoptionsconfiguration.replacespecialcharacters": {
                this.transformationProvider.setReplaceSpecialCharacters(this.replaceOptionsConfigurationPanel.isReplaceSpecialCharacters());
                break;
            }
            case "seda.replaceoptionsconfiguration.replacementstring": {
                this.transformationProvider.setReplacementString(this.replaceOptionsConfigurationPanel.getReplacementString());
                break;
            }
            case "seda.replaceoptionsconfiguration.replacementsmapfile": {
                File file = this.replaceOptionsConfigurationPanel.getReplacementsMapFile();
                if (file == null) {
                    this.transformationProvider.clearReplacementsMapFile();
                    break;
                }
                this.transformationProvider.setReplacementsMapFile(file);
                break;
            }
            case "seda.replaceoptionsconfiguration.savereplacementsmap": {
                this.transformationProvider.setSaveReplacementsMap(this.replaceOptionsConfigurationPanel.isSaveReplacementsMap());
            }
        }
    }

    private Component getNcbiTaxonomyConfigurationPanel() {
        this.ncbiTaxonomyConfigurationPanel = new NcbiTaxonomyConfigurationPanel();
        NcbiRenameConfigurationPanel.addTitledBorder(this.ncbiTaxonomyConfigurationPanel, "NCBI Taxonomy information");
        this.ncbiTaxonomyConfigurationPanel.addPropertyChangeListener(this::ncbiTaxonomyConfigurationPropertyChanged);
        return this.ncbiTaxonomyConfigurationPanel;
    }

    private void ncbiTaxonomyConfigurationPropertyChanged(PropertyChangeEvent event) {
        switch (event.getPropertyName()) {
            case "seda.taxonomyconfiguration.delimiter": {
                this.transformationProvider.setNcbiTaxonomyDelimiter(this.ncbiTaxonomyConfigurationPanel.getDelimiter());
                break;
            }
            case "seda.taxonomyconfiguration.fields": {
                this.transformationProvider.setNcbiTaxonomyFields(this.ncbiTaxonomyConfigurationPanel.getFields());
            }
        }
    }

    private static void addTitledBorder(JComponent component, String title) {
        component.setBorder(BorderFactory.createTitledBorder(title));
    }

    public NcbiRenameTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(NcbiRenameTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        this.fileRenamePanel.setPosition(this.transformationProvider.getFilePosition());
        this.fileRenamePanel.setDelimiter(this.transformationProvider.getFileDelimiter());
        this.sequenceHeaderRenamePanel.setPosition(this.transformationProvider.getSequencePosition());
        this.sequenceHeaderRenamePanel.setDelimiter(this.transformationProvider.getSequenceDelimiter());
        this.sequenceHeaderRenamePanel.setAddIndex(this.transformationProvider.isSequenceAddIndex());
        this.sequenceHeaderRenamePanel.setIndexDelimiter(this.transformationProvider.getSequenceIndexDelimiter());
        this.replaceOptionsConfigurationPanel.setReplaceBlankSpaces(this.transformationProvider.isReplaceBlankSpaces());
        this.replaceOptionsConfigurationPanel.setReplaceSpecialCharacters(this.transformationProvider.isReplaceSpecialCharacters());
        this.replaceOptionsConfigurationPanel.setReplacementString(this.transformationProvider.getReplacementString());
        this.replaceOptionsConfigurationPanel.setSaveReplacementsMap(this.transformationProvider.isSaveReplacementsMap());
        if (this.transformationProvider.isSaveReplacementsMap() && this.transformationProvider.getReplacementsMapFile() != null) {
            this.replaceOptionsConfigurationPanel.setReplacementsMapFile(this.transformationProvider.getReplacementsMapFile());
        }
        this.ncbiTaxonomyConfigurationPanel.setDelimiter(this.transformationProvider.getNcbiTaxonomyDelimiter());
        this.ncbiTaxonomyConfigurationPanel.setFields(this.transformationProvider.getNcbiTaxonomyFields());
    }
}

