/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.datatype.pattern;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.datatype.pattern.EvaluableSequencePattern;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;

@XmlRootElement
public class SequencePatternGroup
implements EvaluableSequencePattern {
    @XmlElement
    private EvaluableSequencePattern.GroupMode mode;
    @XmlAnyElement(lax=true)
    private List<EvaluableSequencePattern> patterns;

    public SequencePatternGroup() {
    }

    public SequencePatternGroup(EvaluableSequencePattern.GroupMode mode, EvaluableSequencePattern ... patterns) {
        this.mode = mode;
        this.patterns = Arrays.asList(patterns);
    }

    @Override
    public boolean eval(String sequence) {
        if (this.patterns.size() > 0) {
            boolean eval = this.patterns.get(0).eval(sequence);
            for (EvaluableSequencePattern pattern : this.patterns.subList(1, this.patterns.size())) {
                boolean patternEval = pattern.eval(sequence);
                if (this.mode.equals((Object)EvaluableSequencePattern.GroupMode.ANY)) {
                    eval = eval || patternEval;
                    continue;
                }
                eval = eval && patternEval;
            }
            return eval;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pattern group [Combination mode:").append((Object)this.mode).append("]: ").append(Stream.of(this.patterns).map(Object::toString).collect(Collectors.joining(",")));
        return sb.toString();
    }

    public EvaluableSequencePattern.GroupMode getMode() {
        return this.mode;
    }

    public List<EvaluableSequencePattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public Validation validate() {
        LinkedList<String> errors = new LinkedList<String>();
        if (this.mode == null) {
            errors.add("The mode can't be null.");
        }
        if (this.patterns == null) {
            errors.add("The patterns list can't be null.");
        } else {
            for (EvaluableSequencePattern p : this.patterns) {
                errors.addAll(p.validate().getValidationErrors());
            }
        }
        return new DefaultValidation(errors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.patterns});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequencePatternGroup other = (SequencePatternGroup)obj;
        return this.mode == other.mode && Objects.equals(this.patterns, other.patterns);
    }
}

