/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.datatype;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.sing_group.seda.datatype.InDiskSequence;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.io.FastaReader;
import org.sing_group.seda.io.FastaWriter;
import org.sing_group.seda.io.IOUtils;
import org.sing_group.seda.io.LineBreakType;

public class InDiskSequencesGroup
implements SequencesGroup {
    private static final FastaReader.SequenceFromLocationsBuilder SEQUENCE_BUILDER = info -> new InDiskSequence(info.getFile(), info.getCharsetSubtype(), info.getNameLocation(), info.getNameLength(), info.getDescriptionLocation(), info.getDescriptionLength(), info.getHeaderLocation(), info.getHeaderLength(), info.getChainLocation(), info.getChainLength(), info.getProperties());
    private final String name;
    private final Path file;
    private final boolean isTempFile;
    private final InDiskSequence[] sequences;
    private Map<String, Object> properties;

    public InDiskSequencesGroup(Path file) {
        this(file, null);
    }

    public InDiskSequencesGroup(Path file, Charset charset) {
        this(file.getFileName().toString(), file, charset);
    }

    public InDiskSequencesGroup(String name, Path file) {
        this(name, file, null);
    }

    public InDiskSequencesGroup(String name, Path file, Charset charset) {
        if (!Files.isRegularFile(file, new LinkOption[0]) && !Files.isReadable(file)) {
            throw new IllegalArgumentException("file should be a regular and readable file");
        }
        this.name = Objects.requireNonNull(name, "name can't be null");
        try {
            this.file = IOUtils.extractIfNeeded(file);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error uncompressing file: " + file, e);
        }
        boolean bl = this.isTempFile = !this.file.equals(file);
        if (this.isTempFile) {
            this.file.toFile().deleteOnExit();
        }
        this.properties = new HashMap<String, Object>();
        this.sequences = (InDiskSequence[])FastaReader.readFasta(this.file, charset, SEQUENCE_BUILDER).toArray(InDiskSequence[]::new);
        if (this.sequences.length > 0) {
            this.populateProperties(charset);
        }
    }

    public InDiskSequencesGroup(String name, Sequence ... sequences) {
        this(name, Collections.emptyMap(), sequences);
    }

    public InDiskSequencesGroup(String name, Map<String, Object> properties, Sequence ... sequences) {
        try {
            this.name = name;
            this.properties = properties;
            this.file = Files.createTempFile("seda_" + name, ".fasta", new FileAttribute[0]);
            this.file.toFile().deleteOnExit();
            this.isTempFile = true;
            this.sequences = this.cloneSequences(sequences);
            this.populateProperties(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error creating temporary file.", e);
        }
    }

    private void populateProperties(Charset charset) {
        if (!this.properties.containsKey("sequence.group.linebreak")) {
            LineBreakType lineBreakType;
            block4: {
                lineBreakType = null;
                try {
                    lineBreakType = LineBreakType.forFile(this.file, charset);
                }
                catch (RuntimeException re) {
                    if (this.sequences.length <= 0) break block4;
                    lineBreakType = LineBreakType.forFile(this.sequences[0].getFile(), charset);
                }
            }
            if (lineBreakType != null && !lineBreakType.equals((Object)LineBreakType.defaultType())) {
                this.properties.put("sequence.group.linebreak", lineBreakType.getLineBreak());
            }
        }
    }

    private InDiskSequence[] cloneSequences(Sequence ... sequences) {
        Sequence[] clonedSequences = Arrays.copyOf(sequences, sequences.length);
        Stream<Sequence> nonLazySequences = Arrays.stream(sequences).filter(sequence -> !(sequence instanceof InDiskSequence));
        FastaWriter.writeFasta(this.file, nonLazySequences);
        FastaReader.readFasta(this.file, FastaWriter.DEFAULT_CHARSET, SEQUENCE_BUILDER).forEach(lazySequence -> {
            boolean found = false;
            for (int i = 0; i < clonedSequences.length; ++i) {
                Sequence sequence = clonedSequences[i];
                if (!sequence.getHeader().equals(lazySequence.getHeader()) || !sequence.getChain().equals(lazySequence.getChain())) continue;
                clonedSequences[i] = lazySequence;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("Error cloning sequence: " + lazySequence.getHeader());
            }
        });
        return (InDiskSequence[])Arrays.stream(clonedSequences).toArray(InDiskSequence[]::new);
    }

    public Path getFile() {
        return this.file;
    }

    public boolean isTempFile() {
        return this.isTempFile;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Stream<Sequence> getSequences() {
        return Arrays.stream(this.sequences);
    }

    @Override
    public int getSequenceCount() {
        return this.sequences.length;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    protected void finalize() throws Throwable {
        if (this.isTempFile) {
            Files.deleteIfExists(this.file);
        }
    }
}

