/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.rename;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.rename.AbstractHeaderRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;

@XmlRootElement
public class WordReplaceRenamer
extends AbstractHeaderRenamer {
    @XmlElement
    private String replacement;
    @XmlElement
    private List<String> targets;
    @XmlElement
    private boolean regex;

    public WordReplaceRenamer() {
        super(HeaderTarget.ALL);
    }

    public WordReplaceRenamer(HeaderTarget target, String replacement, boolean regex, List<String> targets) {
        super(target);
        this.replacement = replacement;
        this.targets = targets;
        this.regex = regex;
    }

    @Override
    public SequencesGroup rename(SequencesGroup sequences, DatatypeFactory factory) {
        LinkedList<Sequence> renamedSequences = new LinkedList<Sequence>();
        for (int i = 0; i < sequences.getSequenceCount(); ++i) {
            Sequence original = sequences.getSequence(i);
            String partToRename = this.getRenamePart(original);
            for (String target : this.targets) {
                if (this.regex) {
                    partToRename = partToRename.replaceAll(target, this.replacement);
                    continue;
                }
                partToRename = partToRename.replace(target, this.replacement);
            }
            renamedSequences.add(this.renameSequence(original, partToRename, factory));
        }
        return this.buildSequencesGroup(sequences.getName(), sequences.getProperties(), renamedSequences, factory);
    }

    public String getReplacement() {
        return this.replacement;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public boolean isRegex() {
        return this.regex;
    }

    @Override
    public Validation validate() {
        ArrayList<String> errors = new ArrayList<String>(super.validate().getValidationErrors());
        if (this.replacement == null) {
            errors.add("The replacement can't be null.");
        }
        if (this.targets == null) {
            errors.add("The targets list can't be null.");
        } else if (this.targets.isEmpty()) {
            errors.add("The targets list can't be empty.");
        } else if (this.isRegex()) {
            for (String target : this.targets) {
                try {
                    Pattern.compile(target);
                }
                catch (PatternSyntaxException e) {
                    errors.add("Target " + target + " isn't a valid regular expression.");
                }
            }
        }
        return new DefaultValidation(errors);
    }
}

