/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.rename;

import java.util.ArrayList;
import java.util.LinkedList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.rename.AbstractHeaderRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.util.StringUtils;

@XmlRootElement
public class AddStringHeaderRenamer
extends AbstractHeaderRenamer {
    @XmlElement
    private String string;
    @XmlElement
    private String delimiter;
    @XmlElement
    private Position position;
    @XmlElement
    private boolean addIndex;
    @XmlElement
    private String indexDelimiter;
    @XmlElement
    private int startIndex;

    public AddStringHeaderRenamer() {
        super(HeaderTarget.ALL);
    }

    public AddStringHeaderRenamer(HeaderTarget target, String string, String delimiter, Position position) {
        this(target, string, delimiter, position, false, "", 0);
    }

    public AddStringHeaderRenamer(HeaderTarget target, String string, String delimiter, Position position, boolean addIndex, String indexDelimiter) {
        this(target, string, delimiter, position, addIndex, indexDelimiter, 1);
    }

    public AddStringHeaderRenamer(HeaderTarget target, String string, String delimiter, Position position, boolean addIndex, String indexDelimiter, int startIndex) {
        super(target);
        this.string = string;
        this.delimiter = delimiter;
        this.position = position;
        this.addIndex = addIndex;
        this.indexDelimiter = indexDelimiter;
        this.startIndex = startIndex;
    }

    @Override
    public SequencesGroup rename(SequencesGroup sequences, DatatypeFactory factory) {
        LinkedList<Sequence> renamedSequences = new LinkedList<Sequence>();
        int start = this.startIndex;
        for (int i = 0; i < sequences.getSequenceCount(); ++i) {
            Sequence original = sequences.getSequence(i);
            String partToRename = this.getRenamePart(original);
            String partToAdd = this.string;
            if (this.addIndex) {
                partToAdd = partToAdd + this.indexDelimiter + String.valueOf(start++);
            }
            String renamedPart = this.position.equals((Object)Position.PREFIX) ? partToAdd + this.delimiter + partToRename : (this.position.equals((Object)Position.SUFFIX) ? partToRename + this.delimiter + partToAdd : partToAdd);
            renamedSequences.add(this.renameSequence(original, renamedPart, factory));
        }
        return this.buildSequencesGroup(sequences.getName(), sequences.getProperties(), renamedSequences, factory);
    }

    public String getString() {
        return this.string;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public Position getPosition() {
        return this.position;
    }

    public boolean isAddIndex() {
        return this.addIndex;
    }

    public String getIndexDelimiter() {
        return this.indexDelimiter;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public Validation validate() {
        ArrayList<String> errors = new ArrayList<String>(super.validate().getValidationErrors());
        if (this.string == null) {
            errors.add("The string can't be null.");
        }
        if (this.delimiter == null) {
            errors.add("The delimiter can't be null.");
        }
        if (this.position == null) {
            errors.add("The position can't be null.");
        }
        if (this.indexDelimiter == null) {
            errors.add("The index delimiter can't be null.");
        }
        return new DefaultValidation(errors);
    }

    public static enum Position {
        PREFIX,
        SUFFIX,
        OVERRIDE;


        public String toString() {
            return StringUtils.capitalize(super.toString());
        }
    }
}

