/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.core.execution.InputLineCallback;

public class AbstractBinariesExecutor {
    public static final String SEDA_EXECUTION_SHOW_COMMANDS = "seda.execution.showcommands";

    protected boolean isShowCommands() {
        return Boolean.valueOf(System.getProperty(SEDA_EXECUTION_SHOW_COMMANDS, "false"));
    }

    protected void showCommands(ProcessBuilder processBuilder) {
        this.showCommands(processBuilder.command());
    }

    protected void showCommands(List<String> parameters) {
        if (this.isShowCommands()) {
            System.out.println(parameters.stream().collect(Collectors.joining(" ")));
        }
    }

    protected void executeCommand(List<String> parameters, File errorFile, File outputFile) throws IOException, InterruptedException {
        ProcessBuilder pBuilder = new ProcessBuilder(parameters.toArray(new String[parameters.size()]));
        this.showCommands(pBuilder);
        pBuilder.redirectError(errorFile);
        pBuilder.redirectOutput(outputFile);
        int result = pBuilder.start().waitFor();
        if (result > 0) {
            String error = Files.readAllLines(errorFile.toPath()).stream().collect(Collectors.joining("\n"));
            String output = Files.readAllLines(outputFile.toPath()).stream().collect(Collectors.joining("\n"));
            throw new IOException("Error running command. Exit status: " + result + ". Error: " + output + "\n" + error);
        }
    }

    protected void executeCommand(List<String> parameters) throws IOException, InterruptedException {
        this.showCommands(parameters);
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(parameters.toArray(new String[parameters.size()]));
        process.waitFor();
    }

    protected void executeCommand(List<String> parameters, File workingDirectory) throws IOException, InterruptedException {
        ProcessBuilder pBuilder = new ProcessBuilder(parameters.toArray(new String[parameters.size()])).directory(workingDirectory);
        this.showCommands(pBuilder);
        pBuilder.start().waitFor();
    }

    protected void executeCommand(List<String> parameters, File workingDirectory, InputLineCallback callBack) throws InterruptedException, IOException {
        String commandString = parameters.stream().collect(Collectors.joining(" "));
        List<InputLineCallback> callBacks = Arrays.asList(callBack);
        ProcessBuilder pBuilder = new ProcessBuilder(parameters.toArray(new String[parameters.size()])).directory(workingDirectory);
        this.showCommands(pBuilder);
        try {
            Process process = pBuilder.start();
            LoggerCallbackInputThread inThread = new LoggerCallbackInputThread(commandString, process.getInputStream(), callBacks);
            LoggerCallbackErrorThread errThread = new LoggerCallbackErrorThread(commandString, process.getErrorStream(), callBacks);
            inThread.start();
            errThread.start();
            process.waitFor();
            inThread.join();
            errThread.join();
        }
        catch (IOException e) {
            AbstractBinariesExecutor.notifyError(callBacks, "Error executing command: " + commandString, e);
            throw new IOException("Error executing command: " + commandString, e);
        }
        finally {
            AbstractBinariesExecutor.inputFinished(callBacks);
        }
    }

    protected static void inputStarted(List<InputLineCallback> callbacks) {
        for (InputLineCallback callback : callbacks) {
            callback.inputStarted();
        }
    }

    protected static void inputFinished(List<InputLineCallback> callbacks) {
        for (InputLineCallback callback : callbacks) {
            callback.inputFinished();
        }
    }

    protected static void notifyInfo(List<InputLineCallback> callbacks, String message) {
        for (InputLineCallback callback : callbacks) {
            callback.info(message);
        }
    }

    protected static void notifyLine(List<InputLineCallback> callbacks, String line) {
        for (InputLineCallback callback : callbacks) {
            callback.line(line);
        }
    }

    protected static void notifyError(List<InputLineCallback> callbacks, String message, Exception e) {
        for (InputLineCallback callback : callbacks) {
            callback.error(message, e);
        }
    }

    protected static class LoggerCallbackErrorThread
    extends Thread {
        private final String command;
        private final BufferedReader reader;
        private final List<InputLineCallback> callbacks;

        public LoggerCallbackErrorThread(String command, InputStream is, List<InputLineCallback> callbacks) {
            this.setDaemon(true);
            this.command = command;
            this.reader = new BufferedReader(new InputStreamReader(is));
            this.callbacks = callbacks;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    AbstractBinariesExecutor.notifyError(this.callbacks, line, null);
                }
            }
            catch (IOException e) {
                AbstractBinariesExecutor.notifyError(this.callbacks, "Error executing command: " + this.command, e);
            }
        }
    }

    protected static class LoggerCallbackInputThread
    extends Thread {
        private final String command;
        private final BufferedReader reader;
        private final List<InputLineCallback> callbacks;

        public LoggerCallbackInputThread(String command, InputStream is, List<InputLineCallback> callbacks) {
            this.setDaemon(true);
            this.command = command;
            this.reader = new BufferedReader(new InputStreamReader(is));
            this.callbacks = callbacks;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    AbstractBinariesExecutor.notifyLine(this.callbacks, line);
                }
            }
            catch (IOException e) {
                AbstractBinariesExecutor.notifyError(this.callbacks, "Error executing command: " + this.command, e);
            }
        }
    }
}

