/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.parameters;

import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.datatype.pattern.EvaluableSequencePattern;
import org.sing_group.seda.datatype.pattern.SequencePattern;
import org.sing_group.seda.datatype.pattern.SequencePatternGroup;

public class MultipleSequencePatternCliParameters {
    private static final String CONFIG_PATTERN_REGEX = "config\\([1-9+]/(true|false)/[1-9+]\\):.+";
    private static final String CONFIG_GROUP_MODE_REGEX = "(?i)[1-9+]:" + Stream.of(EvaluableSequencePattern.GroupMode.values()).map(Enum::name).map(String::toUpperCase).collect(Collectors.joining("|", "(", ")"));
    private static final Boolean DEFAULT_CASE_SENSITIVE = true;
    private static final Integer DEFAULT_MIN_OCURRENCES = 1;
    private static final EvaluableSequencePattern.GroupMode DEFAULT_GROUP_MODE = EvaluableSequencePattern.GroupMode.ANY;
    private final Parameters parameters;
    public static final StringOption OPTION_WITH_PATTERN = new StringOption("with-pattern", "wp", "A pattern (it can be regular expression) that must be present in the sequences.\nIt can be configured adding 'config(group/case_sensitive/min_ocurrences)' before the pattern string, where:\n\t- group (<number>): The group number of the pattern (default is 0). \n\t- case_sensitive (<true/false>): Whether the regular expression must be applied as case sensitive or not (default is false).\n\t- min_ocurrences (<Number>): The minimum number of occurrences that the pattern must be found (default is 1).\nExample: --with-pattern config(1/true/2):<pattern_1_group_1>\nThe default values are used for no config mode.\n", true, true, true);
    public static final StringOption OPTION_WITHOUT_PATTERN = new StringOption("without-pattern", "wop", "A pattern (it can be regular expression) that is not allowed be present in the sequences.\nIt can be configured adding 'config(group/case_sensitive/min_ocurrences)' before the pattern string, where:\n\t- group (<number>): The group number of the pattern (default is 0). \n\t- case_sensitive (<true/false>): Whether the regular expression must be applied as case sensitive or not (default is false).\n\t- min_ocurrences (<Number>): The minimum number of occurrences that the pattern must be found (default is 1).\nExample: --without-pattern config(1/true/2):<pattern_1_group_1>\nThe default values are used for no config mode.\n", true, true, true);
    public static final StringOption OPTION_GROUP_MODE = new StringOption("group-mode", "gm", "Select the mode to group the sequence patterns and/or groups.\nWhen no groups are specified, all patterns are added to the same group in 'any' mode, which means that only one pattern of the group must be present to obtain a match. Using '--group-mode all' means that all patterns must be present at the same time to obtain a match.\nWhen patterns are assigned into groups, the default group mode of each pattern is 'any'. Using '--group-mode <group_number>:all' changes this behaviour. At the same time, all groups are grouped in 'any' mode, which means that only one of the groups must make a match to obtain a global match. Using '--group-mode all' means that all pattern groups must make a match at the same time to obtain a global match.\n", true, true, true);

    public MultipleSequencePatternCliParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public static List<Option<?>> getOptionList() {
        return Arrays.asList(OPTION_WITH_PATTERN, OPTION_WITHOUT_PATTERN, OPTION_GROUP_MODE);
    }

    public SequencePatternGroup getSequencePatternGroup() {
        EvaluableSequencePattern.GroupMode globalGroupMode = this.getGlobalGroupMode();
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        if (this.parameters.hasOption((Option)OPTION_WITH_PATTERN)) {
            try {
                patternList.addAll(this.parameters.getAllValues((Option)OPTION_WITH_PATTERN).stream().map(pattern -> new Pattern((String)pattern, true)).collect(Collectors.toList()));
            }
            catch (IllegalArgumentException e) {
                SedaCommand.invalidOptionValue(OPTION_WITH_PATTERN, "Invalid configuration format for ");
            }
        }
        if (this.parameters.hasOption((Option)OPTION_WITHOUT_PATTERN)) {
            try {
                patternList.addAll(this.parameters.getAllValues((Option)OPTION_WITHOUT_PATTERN).stream().map(pattern -> new Pattern((String)pattern, false)).collect(Collectors.toList()));
            }
            catch (IllegalArgumentException e) {
                SedaCommand.invalidOptionValue(OPTION_WITHOUT_PATTERN, "Invalid configuration format for ");
            }
        }
        List<SequencePatternGroup> patternGroupList = this.getPatternGroupList(patternList, this.getGroupModeList(globalGroupMode));
        return new SequencePatternGroup(globalGroupMode, patternGroupList.toArray(new SequencePatternGroup[patternGroupList.size()]));
    }

    private Map<Integer, EvaluableSequencePattern.GroupMode> getGroupModeList(EvaluableSequencePattern.GroupMode globalGroupMode) {
        Map<Integer, EvaluableSequencePattern.GroupMode> numGroup = new HashMap<Integer, EvaluableSequencePattern.GroupMode>();
        if (this.parameters.hasOption((Option)OPTION_GROUP_MODE)) {
            List groupsModeList = this.parameters.getAllValues((Option)OPTION_GROUP_MODE);
            numGroup = groupsModeList.stream().filter(groupMode -> groupMode.matches(CONFIG_GROUP_MODE_REGEX)).map(this::processGroupConfig).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        numGroup.put(0, globalGroupMode);
        return numGroup;
    }

    private Map<Integer, EvaluableSequencePattern.GroupMode> processGroupConfig(String groupConfig) {
        HashMap<Integer, EvaluableSequencePattern.GroupMode> groupMap = new HashMap<Integer, EvaluableSequencePattern.GroupMode>();
        if (groupConfig.matches(CONFIG_GROUP_MODE_REGEX)) {
            EvaluableSequencePattern.GroupMode groupMode = null;
            try {
                groupMode = EvaluableSequencePattern.GroupMode.valueOf(groupConfig.split(":")[1].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                SedaCommand.invalidEnumValue(OPTION_GROUP_MODE);
            }
            groupMap.put(Integer.parseInt(groupConfig.split(":")[0]), groupMode);
        }
        return groupMap;
    }

    private EvaluableSequencePattern.GroupMode getGlobalGroupMode() {
        EvaluableSequencePattern.GroupMode groupMode = DEFAULT_GROUP_MODE;
        if (this.parameters.hasOption((Option)OPTION_GROUP_MODE)) {
            groupMode = this.parameters.getAllValues((Option)OPTION_GROUP_MODE).stream().filter(s -> !s.matches(CONFIG_GROUP_MODE_REGEX)).findFirst().map(value -> {
                try {
                    return EvaluableSequencePattern.GroupMode.valueOf(value.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    SedaCommand.invalidEnumValue(OPTION_GROUP_MODE);
                    return null;
                }
            }).orElse(EvaluableSequencePattern.GroupMode.ANY);
        }
        return groupMode;
    }

    private List<SequencePatternGroup> getPatternGroupList(List<Pattern> patternList, Map<Integer, EvaluableSequencePattern.GroupMode> groupModeList) {
        ArrayList<SequencePatternGroup> patternGroupList = new ArrayList<SequencePatternGroup>();
        patternList.stream().map(Pattern::getNumGroup).distinct().forEach(groupNum -> {
            List<SequencePattern> sequencePatternList = patternList.stream().filter(pattern -> Objects.equals(pattern.getNumGroup(), groupNum)).map(Pattern::getSequencePattern).collect(Collectors.toList());
            patternGroupList.add(new SequencePatternGroup(groupModeList.getOrDefault(groupNum, DEFAULT_GROUP_MODE), sequencePatternList.toArray(new SequencePattern[sequencePatternList.size()])));
        });
        return patternGroupList;
    }

    private class Pattern {
        private final String pattern;
        private final Boolean contains;
        private final Boolean caseSensitive;
        private final Integer minOccurrences;
        private Integer numGroup;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Pattern(String patternParam, Boolean contains) {
            this.contains = contains;
            if (patternParam.startsWith("config(")) {
                if (!patternParam.matches(MultipleSequencePatternCliParameters.CONFIG_PATTERN_REGEX)) throw new IllegalArgumentException("Invalid config format: " + patternParam);
                this.pattern = patternParam.split(":")[1];
                String config = patternParam.split(":")[0].replace("config", "").replace("(", "").replace(")", "");
                this.numGroup = Integer.parseInt(config.split("/")[0]);
                this.caseSensitive = Boolean.parseBoolean(config.split("/")[1]);
                this.minOccurrences = Integer.parseInt(config.split("/")[2]);
                return;
            } else {
                this.pattern = patternParam;
                this.caseSensitive = DEFAULT_CASE_SENSITIVE;
                this.minOccurrences = DEFAULT_MIN_OCURRENCES;
                this.numGroup = 0;
            }
        }

        public SequencePattern getSequencePattern() {
            return new SequencePattern(this.pattern, this.minOccurrences, this.caseSensitive, this.contains);
        }

        public Integer getNumGroup() {
            return this.numGroup;
        }
    }
}

