/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.split.SequencesGroupSplitMode;
import org.sing_group.seda.plugin.core.info.plugin.SplitSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.split.SplitConfigurationTransformationProvider;

public class SplitCommand
extends SedaCommand {
    public static final FlagOption OPTION_RANDOMIZE = new FlagOption("randomize", "r", "Whether sequences must be randomized or not.");
    public static final IntegerDefaultValuedStringConstructedOption OPTION_SEED = new IntegerDefaultValuedStringConstructedOption("seed", "s", "The random seed to randomize the sequences. This allows the same result to be reproduced in different runs and environments with same random seed.", Integer.valueOf(1));
    public static final DefaultValuedStringOption OPTION_SPLIT_MODE = new DefaultValuedStringOption("split-mode", "sm", SplitSedaPluginInfo.PARAM_SPLIT_MODE_HELP, SequencesGroupSplitMode.FIXED_SEQUENCES_PER_FILE.name().toLowerCase());
    public static final IntegerDefaultValuedStringConstructedOption OPTION_NUM_FILES = new IntegerDefaultValuedStringConstructedOption("num-files", "nf", "The desired number of files.", Integer.valueOf(1));
    public static final IntegerDefaultValuedStringConstructedOption OPTION_NUM_SEQUENCES = new IntegerDefaultValuedStringConstructedOption("num-sequences", "ns", "The desired number of sequences.", Integer.valueOf(1));
    public static final FlagOption OPTION_INDEPENDENT_EXTRACTIONS = new FlagOption("independent-extractions", "ie", SplitSedaPluginInfo.PARAM_INDEPENDENT_EXTRACTIONS_HELP);

    public String getName() {
        return "split";
    }

    public String getDescriptiveName() {
        return "Split";
    }

    public String getDescription() {
        return "Split each input FASTA file into several FASTA files (with the possibilty of random sequence sampling).";
    }

    @Override
    protected String getSedaGroup() {
        return SplitSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        return Arrays.asList(OPTION_RANDOMIZE, OPTION_SEED, OPTION_SPLIT_MODE, OPTION_NUM_FILES, OPTION_NUM_SEQUENCES, OPTION_INDEPENDENT_EXTRACTIONS);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        boolean hasRandomize = parameters.hasFlag((Option)OPTION_RANDOMIZE);
        int seed = (Integer)parameters.getSingleValue((Option)OPTION_SEED);
        int numSequences = (Integer)parameters.getSingleValue((Option)OPTION_NUM_SEQUENCES);
        int numFiles = (Integer)parameters.getSingleValue((Option)OPTION_NUM_FILES);
        boolean hasIndependentExtractions = parameters.hasFlag((Option)OPTION_INDEPENDENT_EXTRACTIONS);
        SequencesGroupSplitMode splitMode = null;
        try {
            splitMode = SequencesGroupSplitMode.valueOf(((String)parameters.getSingleValue((Option)OPTION_SPLIT_MODE)).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SplitCommand.invalidEnumValue(OPTION_SPLIT_MODE);
        }
        return new SplitConfigurationTransformationProvider(splitMode, hasRandomize, seed, hasIndependentExtractions, numFiles, numSequences);
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, SplitConfigurationTransformationProvider.class);
    }
}

