/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.pfam;

import java.util.Optional;
import org.sing_group.seda.pfam.PfamScanSequenceErrorPolicy;

public class PfamScanRequestConfiguration {
    public static final String DEFAULT_DATABASE = "pfam-a";
    public static final double DEFAULT_EVALUE = 10.0;
    public static final int DEFAULT_BATCH_DELAY_FACTOR = 1;
    public static final PfamScanSequenceErrorPolicy DEFAULT_ERROR_POLICY = PfamScanSequenceErrorPolicy.MARK_ERROR;
    private String eMail;
    private String database;
    private boolean activeSitePrediction;
    private Double eValue;
    private PfamScanSequenceErrorPolicy errorPolicy;
    private int batchDelayFactor;

    public PfamScanRequestConfiguration(String eMail, String database, boolean activeSitePredition, PfamScanSequenceErrorPolicy errorPolicy) {
        this(eMail, database, activeSitePredition, errorPolicy, 1, null);
    }

    public PfamScanRequestConfiguration(String eMail, String database, boolean activeSitePredition, PfamScanSequenceErrorPolicy errorPolicy, int batchDelayFactor) {
        this(eMail, database, activeSitePredition, errorPolicy, batchDelayFactor, null);
    }

    public PfamScanRequestConfiguration(String eMail, String database, boolean activeSitePrediction, PfamScanSequenceErrorPolicy errorPolicy, int batchDelayFactor, Double eValue) {
        this.eMail = eMail;
        this.database = database;
        this.activeSitePrediction = activeSitePrediction;
        this.errorPolicy = errorPolicy;
        this.eValue = eValue;
        this.batchDelayFactor = batchDelayFactor;
    }

    public String getEmail() {
        return this.eMail;
    }

    public String getDatabase() {
        return this.database;
    }

    public boolean isActiveSitePrediction() {
        return this.activeSitePrediction;
    }

    public Optional<Double> getEvalue() {
        return Optional.ofNullable(this.eValue);
    }

    public PfamScanSequenceErrorPolicy getErrorPolicy() {
        return this.errorPolicy;
    }

    public int getBatchDelayFactor() {
        return this.batchDelayFactor;
    }
}

