/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.uniprot.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.blast.ncbi.parameters.OutputTypeParameter;
import org.sing_group.seda.blast.plugin.core.UniProtBlastSedaPluginInfo;
import org.sing_group.seda.blast.transformation.provider.uniprot.UniProtBlastTransformationProvider;
import org.sing_group.seda.blast.uniprot.gui.ExpectValueOption;
import org.sing_group.seda.blast.uniprot.gui.HitOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.AlignmentCutoffOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.DatabaseOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.ExpectationOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.FilterOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.MatrixOption;

public class UniProtBlastTransformationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private UniProtBlastTransformationProvider transformationProvider;
    private RadioButtonsPanel<OutputTypeParameter> outputTypeParameter;
    private JComboBox<DatabaseOption> databaseCombobox;
    private JComboBox<ExpectValueOption> expectValue;
    private JComboBox<MatrixOption> matrixCombobox;
    private RadioButtonsPanel<FilterOption> filterRadioButtonsPanel;
    private JCheckBox gapped;
    private JComboBox<HitOption> hitsCombobox;

    public UniProtBlastTransformationConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void initTransformationProvider() {
        this.transformationProvider = new UniProtBlastTransformationProvider(this.getDatabase(), this.getOutputType(), this.getExpectValue(), this.getMatrix(), this.getFilter(), this.isGapped(), this.getHits());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        return new CenteredJPanel((Component)new InputParametersPanel(this.getParameters()));
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> dbParameters = new LinkedList<InputParameter>();
        dbParameters.add(this.getDatabaseParameter());
        dbParameters.add(this.getOutputTypeParameter());
        dbParameters.add(this.getExpectValueParameter());
        dbParameters.add(this.getMatrixParameter());
        dbParameters.add(this.getFilterParameter());
        dbParameters.add(this.getIsGappedParameter());
        dbParameters.add(this.getHitListSizeParameter());
        return dbParameters.toArray(new InputParameter[dbParameters.size()]);
    }

    private InputParameter getDatabaseParameter() {
        this.databaseCombobox = new JComboBox<DatabaseOption>(DatabaseOption.values());
        this.databaseCombobox.addItemListener(this::blastDatabaseChanged);
        return new InputParameter("Database: ", this.databaseCombobox, UniProtBlastSedaPluginInfo.PARAM_DATABASE_HELP_GUI);
    }

    private void blastDatabaseChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(() -> this.transformationProvider.setDatabase(this.getDatabase()));
        }
    }

    private DatabaseOption getDatabase() {
        return (DatabaseOption)this.databaseCombobox.getSelectedItem();
    }

    private InputParameter getOutputTypeParameter() {
        this.outputTypeParameter = new RadioButtonsPanel((Object[])OutputTypeParameter.values(), 1, 2);
        this.outputTypeParameter.setSelectedItem((Object)UniProtBlastSedaPluginInfo.DEFAULT_OUTPUT_TYPE);
        this.outputTypeParameter.addItemListener(this::outputTypeChanged);
        return new InputParameter("Output type: ", this.outputTypeParameter, UniProtBlastSedaPluginInfo.PARAM_OUTPUT_TYPE_HELP_GUI);
    }

    private void outputTypeChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(() -> this.transformationProvider.setOutputType(this.getOutputType()));
        }
    }

    private OutputTypeParameter getOutputType() {
        return (OutputTypeParameter)((Object)this.outputTypeParameter.getSelectedItem().get());
    }

    private InputParameter getExpectValueParameter() {
        this.expectValue = new JComboBox<ExpectValueOption>(this.getExpectValues());
        this.expectValue.setSelectedItem(new ExpectValueOption(UniProtBlastSedaPluginInfo.DEFAULT_EXPECTATION_OPTION));
        this.expectValue.addItemListener(this::expectValueChanged);
        return new InputParameter("E-Threshold:", this.expectValue, UniProtBlastSedaPluginInfo.PARAM_EXPECTATION_VALUE_HELP_GUI);
    }

    private ExpectValueOption[] getExpectValues() {
        ExpectValueOption[] toret = new ExpectValueOption[ExpectationOption.values().length];
        for (int i = 0; i < toret.length; ++i) {
            toret[i] = new ExpectValueOption(ExpectationOption.values()[i]);
        }
        return toret;
    }

    private void expectValueChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(() -> this.transformationProvider.setExpectation(this.getExpectValue()));
        }
    }

    private ExpectationOption getExpectValue() {
        return ((ExpectValueOption)this.expectValue.getSelectedItem()).getExpectationOption();
    }

    private InputParameter getMatrixParameter() {
        this.matrixCombobox = new JComboBox<MatrixOption>(MatrixOption.values());
        this.matrixCombobox.setSelectedItem(UniProtBlastSedaPluginInfo.DEFAULT_MATRIX_OPTION);
        this.matrixCombobox.addItemListener(this::matrixParameterChanged);
        return new InputParameter("Matrix: ", this.matrixCombobox, UniProtBlastSedaPluginInfo.PARAM_MATRIX_OPTION_HELP_GUI);
    }

    private void matrixParameterChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(() -> this.transformationProvider.setMatrix(this.getMatrix()));
        }
    }

    private MatrixOption getMatrix() {
        return (MatrixOption)this.matrixCombobox.getSelectedItem();
    }

    private InputParameter getFilterParameter() {
        this.filterRadioButtonsPanel = new RadioButtonsPanel((Object[])FilterOption.values(), 1, 2);
        this.filterRadioButtonsPanel.setSelectedItem((Object)UniProtBlastSedaPluginInfo.DEFAULT_FILTER_OPTION);
        this.filterRadioButtonsPanel.addItemListener(this::filtereParameterChanged);
        return new InputParameter("Filtering: ", this.filterRadioButtonsPanel, UniProtBlastSedaPluginInfo.PARAM_FILTER_HELP_GUI);
    }

    private void filtereParameterChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(() -> this.transformationProvider.setFilter(this.getFilter()));
        }
    }

    private FilterOption getFilter() {
        return (FilterOption)this.filterRadioButtonsPanel.getSelectedItem().get();
    }

    private InputParameter getIsGappedParameter() {
        this.gapped = new JCheckBox();
        this.gapped.setSelected(true);
        this.gapped.addItemListener(this::gappedChanged);
        return new InputParameter("Gapped: ", (JComponent)this.gapped, UniProtBlastSedaPluginInfo.PARAM_GAPPED_HELP_GUI);
    }

    private void gappedChanged(ItemEvent event) {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setGapped(this.isGapped()));
    }

    private boolean isGapped() {
        return this.gapped.isSelected();
    }

    private InputParameter getHitListSizeParameter() {
        this.hitsCombobox = new JComboBox<HitOption>(this.getHitValues());
        this.hitsCombobox.setSelectedItem(new HitOption(UniProtBlastSedaPluginInfo.DEFAULT_ALIGNMENT_CUTOFF));
        this.hitsCombobox.addItemListener(this::hitsChanged);
        return new InputParameter("Hits: ", this.hitsCombobox, UniProtBlastSedaPluginInfo.PARAM_HITS_HELP_GUI);
    }

    public HitOption[] getHitValues() {
        HitOption[] toret = new HitOption[AlignmentCutoffOption.values().length];
        for (int i = 0; i < toret.length; ++i) {
            toret[i] = new HitOption(AlignmentCutoffOption.values()[i]);
        }
        return toret;
    }

    private void hitsChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(() -> this.transformationProvider.setHits(this.getHits()));
        }
    }

    private AlignmentCutoffOption getHits() {
        return ((HitOption)this.hitsCombobox.getSelectedItem()).getCutoff();
    }

    public UniProtBlastTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(UniProtBlastTransformationProvider transformationProvider) {
        MatrixOption matrix;
        AlignmentCutoffOption hits;
        FilterOption filter;
        ExpectationOption expectValue;
        OutputTypeParameter outputType;
        this.transformationProvider = transformationProvider;
        DatabaseOption database = this.transformationProvider.getDatabase();
        if (database != null) {
            this.databaseCombobox.setSelectedItem(database);
        }
        if ((outputType = this.transformationProvider.getOutputType()) != null) {
            this.outputTypeParameter.setSelectedItem((Object)outputType);
        }
        if ((expectValue = this.transformationProvider.getExpectValue()) != null) {
            this.expectValue.setSelectedItem(new ExpectValueOption(expectValue));
        }
        if ((filter = this.transformationProvider.getFilter()) != null) {
            this.filterRadioButtonsPanel.setSelectedItem((Object)filter);
        }
        if ((hits = this.transformationProvider.getHits()) != null) {
            this.hitsCombobox.setSelectedItem(new HitOption(hits));
        }
        if ((matrix = this.transformationProvider.getMatrix()) != null) {
            this.matrixCombobox.setSelectedItem(matrix);
        }
        this.gapped.setSelected(this.transformationProvider.isGapped());
    }
}

