/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.plugin.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.sing_group.seda.blast.ncbi.gui.NcbiBlastTransformationConfigurationPanel;
import org.sing_group.seda.blast.plugin.core.NcbiBlastSedaPluginInfo;
import org.sing_group.seda.blast.transformation.provider.ncbi.NcbiBlastTransformationProvider;
import org.sing_group.seda.core.SedaContext;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public class NcbiBlastSedaGuiPlugin
extends AbstractSedaGuiPlugin {
    private NcbiBlastTransformationConfigurationPanel configurationPanel = new NcbiBlastTransformationConfigurationPanel();

    @Override
    public String getName() {
        return "NCBI BLAST";
    }

    @Override
    public String getGroupName() {
        return NcbiBlastSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Perform a BLAST query through the NCBI web server (https://blast.ncbi.nlm.nih.gov/Blast.cgi).";
    }

    @Override
    public Component getEditor() {
        return this.configurationPanel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.configurationPanel.getTransformationProvider();
    }

    @Override
    public void setSedaContext(SedaContext context) {
        super.setSedaContext(context);
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<NcbiBlastTransformationProvider>().write(this.configurationPanel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.configurationPanel.setTransformationProvider((NcbiBlastTransformationProvider)new JsonObjectReader().read(file, NcbiBlastTransformationProvider.class));
    }
}

