/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.ncbi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class NcbiEutils {
    private static final String BASE_URL = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi";
    private static final int DELAY = 2000;
    private static final int BATCH_SIZE = 100;

    public static void downloadFasta(File output, List<String> uids, String entrezDatabase) throws URISyntaxException, ClientProtocolException, IOException {
        for (int i = 0; i < uids.size(); i += 100) {
            int start = i;
            int end = Math.min(i + 100, uids.size());
            NcbiEutils._downloadFasta(output, uids.subList(start, end), entrezDatabase);
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _downloadFasta(File output, List<String> uids, String entrezDatabase) throws URISyntaxException, ClientProtocolException, IOException {
        block10: {
            URIBuilder ub = new URIBuilder(BASE_URL);
            ub.addParameter("db", entrezDatabase);
            ub.addParameter("id", uids.stream().collect(Collectors.joining(",")));
            ub.addParameter("rettype", "fasta");
            ub.addParameter("retmode", "text");
            HttpGet httpGet = new HttpGet(ub.toString());
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                if (response.getEntity() != null) {
                    // empty if block
                }
                try (FileOutputStream outstream = new FileOutputStream(output, true);){
                    response.getEntity().writeTo((OutputStream)outstream);
                    break block10;
                }
                finally {
                    httpClient.close();
                }
            }
            throw new IOException("Query failed");
        }
    }
}

