/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.cli.uniprot;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.sing_group.seda.blast.ncbi.parameters.OutputTypeParameter;
import org.sing_group.seda.blast.plugin.core.UniProtBlastSedaPluginInfo;
import org.sing_group.seda.blast.transformation.provider.uniprot.UniProtBlastTransformationProvider;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.AlignmentCutoffOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.DatabaseOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.ExpectationOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.FilterOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.MatrixOption;

public class UniProtBlastCommand
extends SedaCommand {
    public static final DefaultValuedStringOption OPTION_DATABASE = new DefaultValuedStringOption("database", "db", UniProtBlastSedaPluginInfo.PARAM_DATABASE_HELP, UniProtBlastSedaPluginInfo.DEFAULT_DATABASE_OPTION.name().toLowerCase());
    public static final DefaultValuedStringOption OPTION_OUTPUT_TYPE = new DefaultValuedStringOption("output-type", "ot", UniProtBlastSedaPluginInfo.PARAM_OUTPUT_TYPE_HELP, UniProtBlastSedaPluginInfo.DEFAULT_OUTPUT_TYPE.name().toLowerCase());
    public static final DefaultValuedStringOption OPTION_EXPECTATION_VALUE = new DefaultValuedStringOption("expectation-value", "e", UniProtBlastSedaPluginInfo.PARAM_EXPECTATION_VALUE_HELP, UniProtBlastSedaPluginInfo.DEFAULT_EXPECTATION_OPTION.name().toLowerCase());
    public static final DefaultValuedStringOption OPTION_MATRIX_OPTION = new DefaultValuedStringOption("matrix", "m", UniProtBlastSedaPluginInfo.PARAM_MATRIX_OPTION_HELP, UniProtBlastSedaPluginInfo.DEFAULT_MATRIX_OPTION.name().toLowerCase());
    public static final DefaultValuedStringOption OPTION_FILTER = new DefaultValuedStringOption("filter", "f", UniProtBlastSedaPluginInfo.PARAM_FILTER_HELP, UniProtBlastSedaPluginInfo.DEFAULT_FILTER_OPTION.name().toLowerCase());
    public static final FlagOption GAPPED_OPTION = new FlagOption("gapped", "g", "Whether the query is gapped or not. This will allow gaps to be introduced in the sequences when the comparison is done.");
    public static final DefaultValuedStringOption OPTION_HITS = new DefaultValuedStringOption("hits", "h", UniProtBlastSedaPluginInfo.PARAM_HITS_HELP, UniProtBlastSedaPluginInfo.DEFAULT_ALIGNMENT_CUTOFF.name().toLowerCase());

    public String getName() {
        return "blast-uniprot";
    }

    public String getDescriptiveName() {
        return "UniProt BLAST";
    }

    public String getDescription() {
        return "Perform a BLAST query through the UniProt web server (https://www.uniprot.org/blast/).";
    }

    @Override
    protected String getSedaGroup() {
        return UniProtBlastSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        return Arrays.asList(OPTION_DATABASE, OPTION_OUTPUT_TYPE, OPTION_EXPECTATION_VALUE, OPTION_MATRIX_OPTION, OPTION_FILTER, GAPPED_OPTION, OPTION_HITS);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        UniProtBlastTransformationProvider provider = new UniProtBlastTransformationProvider();
        provider.setDatabase(UniProtBlastCommand.getEnumValue(parameters, DatabaseOption.class, OPTION_DATABASE));
        provider.setOutputType(UniProtBlastCommand.getEnumValue(parameters, OutputTypeParameter.class, OPTION_OUTPUT_TYPE));
        provider.setExpectation(UniProtBlastCommand.getEnumValue(parameters, ExpectationOption.class, OPTION_EXPECTATION_VALUE));
        provider.setMatrix(UniProtBlastCommand.getEnumValue(parameters, MatrixOption.class, OPTION_MATRIX_OPTION));
        provider.setFilter(UniProtBlastCommand.getEnumValue(parameters, FilterOption.class, OPTION_FILTER));
        provider.setGapped(parameters.hasFlag((Option)GAPPED_OPTION));
        provider.setHits(UniProtBlastCommand.getEnumValue(parameters, AlignmentCutoffOption.class, OPTION_HITS));
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, UniProtBlastTransformationProvider.class);
    }
}

