/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.gui.execution;

import java.util.Optional;
import javax.swing.JPanel;
import org.sing_group.seda.sapp.execution.DefaultSappCommands;
import org.sing_group.seda.sapp.execution.SappCommands;
import org.sing_group.seda.sapp.execution.SappEnvironment;

public abstract class AbstractSappCommandsConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String JAVA_PATH_PROPERTY = "commands.javapath";
    public static final String SAPP_JARS_PATH_PROPERTY = "commands.sappjarspath";
    private SappEnvironment environment;

    public AbstractSappCommandsConfigurationPanel() {
        this(SappEnvironment.getInstance());
    }

    public AbstractSappCommandsConfigurationPanel(SappEnvironment environment) {
        this.environment = environment;
    }

    public SappCommands sappCommands() {
        if (this.selectedJavaPath().isPresent()) {
            return new DefaultSappCommands(this.selectedJavaPath().get() + "/java", this.conversionJarPath(), this.geneCallerJarPath());
        }
        return new DefaultSappCommands(this.conversionJarPath(), this.geneCallerJarPath());
    }

    public String conversionJarPath() {
        return this.selectedSappJarsPath().orElse("") + "/" + this.environment.getConversionJar();
    }

    public String geneCallerJarPath() {
        return this.selectedSappJarsPath().orElse("") + "/" + this.environment.getGeneCallerJar();
    }

    protected abstract Optional<String> selectedJavaPath();

    protected abstract Optional<String> selectedSappJarsPath();
}

