/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.prosplign.transformation.provider;

import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.execution.BlastBinariesExecutorWrapper;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.prosplign.execution.ProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.transformation.dataset.ProSplignCompartPipelineSequencesGroupDatasetTransformation;
import org.sing_group.seda.prosplign.transformation.provider.ProSplignCompartPipelineTransformationConfigurationChangeType;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

@XmlRootElement
public class ProSplignCompartPipelineTransformationProvider
extends AbstractTransformationProvider {
    @XmlAnyElement(lax=true)
    private ProSplignCompartBinariesExecutor proSplignCompartBinariesExecutor;
    @XmlElement
    private BlastBinariesExecutorWrapper blastBinariesExecutor = new BlastBinariesExecutorWrapper();
    @XmlElement
    private File proteinQueryFile;
    @XmlElement
    private int maxTargetSeqs;

    @Override
    public Validation validate() {
        try {
            LinkedList<String> validationErrors = new LinkedList<String>();
            if (this.proteinQueryFile == null) {
                validationErrors.add("The protein query file can't be null");
            }
            if (!this.isValidProSplignCompartBinariesExecutor()) {
                validationErrors.add("The ProSplign/ProCompart binaries executor is not valid");
            }
            if (!this.isValidBlastBinariesExecutor()) {
                validationErrors.add("The BLAST binaries executor is not valid");
            }
            if (validationErrors.isEmpty()) {
                this.getTransformation(DatatypeFactory.getDefaultDatatypeFactory());
                return new DefaultValidation(new String[0]);
            }
            return new DefaultValidation(validationErrors);
        }
        catch (RuntimeException ex) {
            return new DefaultValidation(ex.toString());
        }
    }

    private boolean isValidProSplignCompartBinariesExecutor() {
        if (this.proSplignCompartBinariesExecutor == null) {
            return false;
        }
        try {
            this.proSplignCompartBinariesExecutor.checkBinary();
            return true;
        }
        catch (BinaryCheckException e) {
            return false;
        }
    }

    private boolean isValidBlastBinariesExecutor() {
        if (this.blastBinariesExecutor.get() == null) {
            return false;
        }
        try {
            this.blastBinariesExecutor.get().checkBinary();
            return true;
        }
        catch (BinaryCheckException e) {
            return false;
        }
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return this.getProSplignCompartPipelineTransformation(factory);
    }

    private ProSplignCompartPipelineSequencesGroupDatasetTransformation getProSplignCompartPipelineTransformation(DatatypeFactory factory) {
        return new ProSplignCompartPipelineSequencesGroupDatasetTransformation(factory, this.proSplignCompartBinariesExecutor, this.blastBinariesExecutor.get(), this.proteinQueryFile, this.maxTargetSeqs);
    }

    public void setProSplignCompartBinariresExecutor(Optional<ProSplignCompartBinariesExecutor> proSplignCompartBinariesExecutor) {
        this.proSplignCompartBinariesExecutor = proSplignCompartBinariesExecutor.orElse(null);
        this.fireTransformationsConfigurationModelEvent(ProSplignCompartPipelineTransformationConfigurationChangeType.PRO_SPLIGN_COMPART_EXECUTOR_CHANGED, this.proSplignCompartBinariesExecutor);
    }

    public ProSplignCompartBinariesExecutor getProSplignCompartBinariesExecutor() {
        return this.proSplignCompartBinariesExecutor;
    }

    public void setBlastBinariesExecutor(Optional<BlastBinariesExecutor> blastBinariesExecutor) {
        this.blastBinariesExecutor.set((BlastBinariesExecutor)blastBinariesExecutor.orElse(null));
        this.fireTransformationsConfigurationModelEvent(ProSplignCompartPipelineTransformationConfigurationChangeType.BLAST_EXECUTOR_CHANGED, this.blastBinariesExecutor.get());
    }

    public BlastBinariesExecutor getBlastBinariesExecutor() {
        return this.blastBinariesExecutor.get();
    }

    public void clearProteinQueryFile() {
        this.proteinQueryFile = null;
        this.fireTransformationsConfigurationModelEvent(ProSplignCompartPipelineTransformationConfigurationChangeType.QUERY_FILE_CHANGED, this.proteinQueryFile);
    }

    public void setProteinQueryFile(File proteinQueryFile) {
        if (this.proteinQueryFile == null || !this.proteinQueryFile.equals(proteinQueryFile)) {
            this.proteinQueryFile = proteinQueryFile;
            this.fireTransformationsConfigurationModelEvent(ProSplignCompartPipelineTransformationConfigurationChangeType.QUERY_FILE_CHANGED, this.proteinQueryFile);
        }
    }

    public File getProteinQueryFile() {
        return this.proteinQueryFile;
    }

    public void setMaxTargetSeqs(int maxTargetSeqs) {
        if (this.maxTargetSeqs != maxTargetSeqs) {
            this.maxTargetSeqs = maxTargetSeqs;
            this.fireTransformationsConfigurationModelEvent(ProSplignCompartPipelineTransformationConfigurationChangeType.MAX_TARGET_SEQS_CHANGED, this.maxTargetSeqs);
        }
    }

    public int getMaxTargetSeqs() {
        return this.maxTargetSeqs;
    }
}

