/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cga.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import org.sing_group.gc4s.event.RunnableDocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanelBuilder;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.cga.execution.CgaBinariesExecutor;
import org.sing_group.seda.cga.execution.DefaultDockerCgaBinariesExecutor;
import org.sing_group.seda.cga.gui.CgaCompiPipelineConfigurationParameters;
import org.sing_group.seda.cga.gui.DockerExecutionConfigurationPanel;
import org.sing_group.seda.cga.plugin.core.CgaPipelineSedaPluginInfo;
import org.sing_group.seda.cga.transformation.dataset.CgaResults;
import org.sing_group.seda.cga.transformation.provider.CgaPipelineTransformationProvider;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;

public class CgaPipelineTransformationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private CgaPipelineTransformationProvider transformationProvider;
    private DockerExecutionConfigurationPanel cgaExecutionConfigurationPanel;
    private JFileChooserPanel referenceFasta;
    private CgaCompiPipelineConfigurationParameters cgaCompiPipelineConfigurationParameters;
    private JComboBox<CgaResults> cgaResults;
    private JIntegerTextField compiTasks;

    public CgaPipelineTransformationConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void initTransformationProvider() {
        this.transformationProvider = new CgaPipelineTransformationProvider();
        this.cgaExecutorChanged();
        this.cgaCompiPipelineConfigurationChanged();
        this.referenceFastaChanged();
        this.cgaResultsChanged();
        this.compiTasksChanged();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add((Component)this.getQueryConfigurationPanel());
        return new CenteredJPanel((Component)mainPanel);
    }

    private InputParametersPanel getQueryConfigurationPanel() {
        return new InputParametersPanel(this.getParameters());
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getSplignCompartExecutableParameter());
        parameters.add(this.getGenomeQueryFileParameter());
        parameters.addAll(this.getCgaCompiPipelineConfigurationParameters());
        parameters.add(this.getCgaResultsParameter());
        parameters.add(this.getCompiTasksParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getSplignCompartExecutableParameter() {
        this.cgaExecutionConfigurationPanel = new DockerExecutionConfigurationPanel();
        this.cgaExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this::cgaExecutorChanged);
        return new InputParameter("CGA Docker image:", (JComponent)this.cgaExecutionConfigurationPanel, CgaPipelineSedaPluginInfo.PARAM_DOCKER_MODE_HELP_GUI);
    }

    private void cgaExecutorChanged(BinaryExecutionConfigurationPanel<CgaBinariesExecutor> source) {
        this.cgaExecutorChanged();
    }

    private void cgaExecutorChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setCgaBinariesExecutor(this.cgaExecutionConfigurationPanel.getBinariesExecutor()));
    }

    private InputParameter getGenomeQueryFileParameter() {
        this.referenceFasta = JFileChooserPanelBuilder.createOpenJFileChooserPanel().withFileChooser(CommonFileChooser.getInstance().getFilechooser()).withFileChooserSelectionMode(SelectionMode.FILES).withLabel("").withClearSelectedFileOnShow(true).build();
        this.referenceFasta.addFileChooserListener(e -> this.referenceFastaChanged());
        return new InputParameter("Reference FASTA file:", (JComponent)this.referenceFasta, "FASTA file containing the reference sequence.");
    }

    private void referenceFastaChanged() {
        SwingUtilities.invokeLater(() -> {
            if (this.referenceFasta.getSelectedFile() != null) {
                this.transformationProvider.setReferenceFasta(this.referenceFasta.getSelectedFile());
            } else {
                this.transformationProvider.clearQueryFile();
            }
        });
    }

    private List<InputParameter> getCgaCompiPipelineConfigurationParameters() {
        this.cgaCompiPipelineConfigurationParameters = new CgaCompiPipelineConfigurationParameters(this::cgaCompiPipelineConfigurationChanged);
        return Arrays.asList(this.cgaCompiPipelineConfigurationParameters.getParameters());
    }

    private void cgaCompiPipelineConfigurationChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setCgaCompiPipelineConfiguration(this.cgaCompiPipelineConfigurationParameters.getConfiguration()));
    }

    private InputParameter getCgaResultsParameter() {
        this.cgaResults = new JComboBox<CgaResults>(CgaResults.values());
        this.cgaResults.addItemListener(this::cgaResultsChanged);
        return new InputParameter("Results:", this.cgaResults, "The CGA results to collect.");
    }

    private void cgaResultsChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.cgaResultsChanged();
        }
    }

    private void cgaResultsChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setCgaResults((CgaResults)((Object)((Object)this.cgaResults.getSelectedItem()))));
    }

    private InputParameter getCompiTasksParameter() {
        this.compiTasks = new JIntegerTextField(Integer.valueOf(4));
        this.compiTasks.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::compiTasksChanged));
        return new InputParameter("Parallell tasks:", (JComponent)this.compiTasks, "The maximum number of parallell tasks that the Compi pipeline may execute.");
    }

    private void compiTasksChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setCompiTasks(this.compiTasks.getValue()));
    }

    public CgaPipelineTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(CgaPipelineTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        if (this.transformationProvider.getreferenceFasta() != null) {
            this.referenceFasta.setSelectedFile(this.transformationProvider.getreferenceFasta());
        } else {
            this.transformationProvider.clearQueryFile();
        }
        if (this.transformationProvider.getcgaBinariesExecutor() != null) {
            this.cgaExecutionConfigurationPanel.setSelectedDockerImage(((DefaultDockerCgaBinariesExecutor)this.transformationProvider.getcgaBinariesExecutor()).getDockerImage());
        }
        if (this.transformationProvider.getCgaResults() != null) {
            this.cgaResults.setSelectedItem((Object)this.transformationProvider.getCgaResults());
        }
        this.compiTasks.setValue((Object)this.transformationProvider.getCompiTasks());
        if (this.transformationProvider.getCgaCompiPipelineConfiguration() != null) {
            this.cgaCompiPipelineConfigurationParameters.setConfiguration(this.transformationProvider.getCgaCompiPipelineConfiguration());
        }
    }
}

