/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.util;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;

public class FileUtils {
    public static void writeMap(File file, Map<String, String> map) throws IOException {
        if (file != null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                sb.append(entry.getKey()).append("\t").append(entry.getValue()).append(System.lineSeparator());
            }
            Files.write(file.toPath(), sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public static Optional<Path> getTemporaryClipboardFile() {
        try {
            return FileUtils.writeClipboardToPath(Files.createTempFile("seda-temporary-clipboard-", ".fasta", new FileAttribute[0]));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static Optional<Path> writeClipboardToPath(Path path) {
        try {
            String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            if (!data.trim().isEmpty()) {
                Files.write(path, data.replace("\n", System.lineSeparator()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                return Optional.of(path);
            }
            return Optional.empty();
        }
        catch (HeadlessException | UnsupportedFlavorException | IOException e) {
            return Optional.empty();
        }
    }

    public static void deleteIfExists(File directory) throws IOException {
        FileUtils.deleteIfExists(directory.toPath());
    }

    public static void deleteIfExists(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                throw new IllegalArgumentException("input path must be a directory");
            }
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

