/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.statistics;

import java.awt.Frame;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import org.jdesktop.swingx.JXTable;
import org.sing_group.gc4s.event.PopupMenuAdapter;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.gc4s.utilities.ExtendedAbstractAction;
import org.sing_group.gc4s.visualization.table.ColumnSummaryTableCellRenderer;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.gui.AbstractVisualizationDialog;
import org.sing_group.seda.gui.CustomSwingWorker;
import org.sing_group.seda.gui.WorkingDialog;
import org.sing_group.seda.gui.statistics.SequencesGroupDatasetStatisticsTableModel;
import org.sing_group.seda.gui.statistics.SequencesGroupFastaViewer;
import org.sing_group.seda.gui.statistics.SequencesGroupStatisticsTable;
import org.sing_group.seda.gui.statistics.SequencesGroupStatisticsTableModel;

public class SequencesGroupDatasetStatisticsTable
extends JXTable {
    private static final long serialVersionUID = 1L;
    private ExtendedAbstractAction showSequenceInfo;
    private ExtendedAbstractAction showFastaFile;
    private SequencesGroupDatasetStatisticsTableModel model;

    public SequencesGroupDatasetStatisticsTable(SequencesGroupDatasetStatisticsTableModel tm) {
        super(tm);
        this.model = tm;
        this.setSelectionMode(0);
        this.setComponentPopupMenu(this.getPopupMenu());
        this.setTableHeader();
        this.packAll();
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.getShowSequenceInfoAction());
        menu.add(this.getShowFastaFileAction());
        menu.addPopupMenuListener(new PopupMenuAdapter(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SequencesGroupDatasetStatisticsTable.this.showSequenceInfo.setEnabled(SequencesGroupDatasetStatisticsTable.this.getSelectedRowCount() > 0);
                SequencesGroupDatasetStatisticsTable.this.showFastaFile.setEnabled(SequencesGroupDatasetStatisticsTable.this.getSelectedRowCount() > 0);
            }
        });
        return menu;
    }

    private Action getShowSequenceInfoAction() {
        this.showSequenceInfo = new ExtendedAbstractAction("Show file statistics", this::showStatistics);
        this.showSequenceInfo.setEnabled(false);
        return this.showSequenceInfo;
    }

    private void showStatistics() {
        if (this.getSelectedRowCount() > 0) {
            this.showSelectedRowStatistics();
        }
    }

    private void showSelectedRowStatistics() {
        int rowModel = this.convertRowIndexToModel(this.getSelectedRow());
        SequencesGroup sequencesGroup = this.model.getSequencesGroupAt(rowModel);
        this.createAndShowStatistics(sequencesGroup);
    }

    private void createAndShowStatistics(SequencesGroup sequencesGroup) {
        WorkingDialog dialog = new WorkingDialog((Frame)((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this)), "Statistics", "Reading file and calculating statistics");
        new CustomSwingWorker(() -> {
            SequencesGroupStatisticsTable table = new SequencesGroupStatisticsTable(new SequencesGroupStatisticsTableModel(sequencesGroup.getSequences().collect(Collectors.toList())));
            dialog.dispose();
            AbstractVisualizationDialog.visualize(SwingUtilities.getWindowAncestor(this), new CenteredJPanel(new JScrollPane(table)), "Statistics for file: " + sequencesGroup.getName());
        }).execute();
        dialog.setVisible(true);
    }

    private Action getShowFastaFileAction() {
        this.showFastaFile = new ExtendedAbstractAction("Show FASTA file", this::showFastaFile);
        this.showFastaFile.setEnabled(false);
        return this.showFastaFile;
    }

    private void showFastaFile() {
        if (this.getSelectedRowCount() > 0) {
            this.showSelectedFastaFile();
        }
    }

    private void showSelectedFastaFile() {
        int rowModel = this.convertRowIndexToModel(this.getSelectedRow());
        SequencesGroup sequencesGroup = this.model.getSequencesGroupAt(rowModel);
        this.createAndShowSequences(sequencesGroup);
    }

    private void createAndShowSequences(SequencesGroup sequencesGroup) {
        WorkingDialog dialog = new WorkingDialog((Frame)((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this)), "FASTA file", "Reading FASTA file");
        new CustomSwingWorker(() -> {
            SequencesGroupFastaViewer viewer = new SequencesGroupFastaViewer(sequencesGroup);
            dialog.dispose();
            AbstractVisualizationDialog.visualize(SwingUtilities.getWindowAncestor(this), new CenteredJPanel(new JScrollPane(viewer)), "FASTA file: " + sequencesGroup.getName());
        }).execute();
        dialog.setVisible(true);
    }

    private void setTableHeader() {
        this.getTableHeader().setDefaultRenderer(new ColumnSummaryTableCellRenderer(this.getTableHeader().getDefaultRenderer(), Arrays.asList(1, 2, 3), this.getModel()));
    }
}

