/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.translation;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.gui.configuration_panel.translation.SequenceTranslationConfigurationPanel;
import org.sing_group.seda.gui.configuration_panel.translation.SequenceTranslationPanelPropertyChangeAdapter;
import org.sing_group.seda.transformation.provider.translation.TranslateSequencesTransformationProvider;

public class TranslateSequencesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SequenceTranslationConfigurationPanel sequenceTranslationConfigurationPanel;
    private TranslateSequencesTransformationProvider transformationProvider;

    public TranslateSequencesPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.sequenceTranslationConfigurationPanel = new SequenceTranslationConfigurationPanel(false);
        this.sequenceTranslationConfigurationPanel.addPropertyChangeListener(new SequenceTranslationPanelPropertyChangeAdapter(){

            @Override
            protected void translationPropertyChanged() {
                TranslateSequencesPanel.this.translationConfigurationChanged();
            }

            @Override
            protected void joinFramesPropertyChanged() {
                TranslateSequencesPanel.this.translationConfigurationChanged();
            }

            @Override
            protected void framesPropertyChanged() {
                TranslateSequencesPanel.this.translationConfigurationChanged();
            }

            @Override
            protected void codonTablePropertyChanged() {
                TranslateSequencesPanel.this.translationConfigurationChanged();
            }

            @Override
            protected void reverseSequencesPropertyChanged() {
                TranslateSequencesPanel.this.translationConfigurationChanged();
            }
        });
        this.add((Component)new CenteredJPanel(this.sequenceTranslationConfigurationPanel), "Center");
    }

    private void translationConfigurationChanged() {
        if (this.sequenceTranslationConfigurationPanel.isValidUserSelection()) {
            this.transformationProvider.setTranslationConfiguration(this.sequenceTranslationConfigurationPanel.getSequenceTranslationConfiguration());
        } else {
            this.transformationProvider.clearTranslationConfiguration();
        }
    }

    private void initTransformationProvider() {
        this.transformationProvider = new TranslateSequencesTransformationProvider();
        this.translationConfigurationChanged();
    }

    public TranslateSequencesTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(TranslateSequencesTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        if (transformationProvider.getTranslationConfiguration() != null) {
            this.sequenceTranslationConfigurationPanel.setSequenceTranslationConfiguration(transformationProvider.getTranslationConfiguration());
        }
    }
}

