/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.translation;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.combobox.ComboBoxItem;
import org.sing_group.gc4s.input.combobox.ExtendedJComboBox;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.gc4s.visualization.table.MapTableViewer;
import org.sing_group.seda.core.ncbi.codes.NcbiCodonTables;
import org.sing_group.seda.datatype.configuration.SequenceTranslationConfiguration;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.GuiUtils;
import org.sing_group.seda.plugin.core.info.common.SequenceTranslationInfo;

public class SequenceTranslationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CUTOM_TABLE_INFO_LABEL = SequenceTranslationInfo.PARAM_CODON_TABLE_CUSTOM_HELP_GUI;
    private static final String SHOW_CUTOM_TABLE_TOOLTIP = "<html>Make double-click here to see the current codon table.</html>";
    private static final String JOIN_FRAMES_INFO_LABEL = SequenceTranslationInfo.PARAM_JOIN_FRAME_HELP_GUI;
    private static final String REVERSE_SEQUENCES_INFO_LABEL = "Whether reverse complement of sequences must be calculated before translation or not. If not selected, sequences are used as they are introduced.";
    public static final String PROPERTY_JOIN_FRAMES = "seda.sequencetranslationpanel.joinframes";
    public static final String PROPERTY_FRAMES = "seda.sequencetranslationpanel.frames";
    public static final String PROPERTY_CODON_TABLE = "seda.sequencetranslationpanel.codontable";
    public static final String PROPERTY_REVERSE_SEQUENCES = "seda.sequencetranslationpanel.reversesequences";
    private boolean ignoreGuiEvents = false;
    private boolean showJoinFramesCheckbox;
    private NcbiCodonTables ncbiCodonTables;
    private JIntegerTextField fixedFrameTf;
    private JRadioButton fixedFrameRb;
    private JCheckBox joinFramesCb;
    private JRadioButton allFramesRb;
    private JRadioButton customCodonTableRb;
    private JRadioButton predefinedCodonTableRb;
    private Map<Integer, Integer> codonIdentifierToItemIndex;
    private ExtendedJComboBox<ComboBoxItem<Integer>> predefinedCodonTableCombo;
    private Map<String, String> customCodonTable = Collections.emptyMap();
    private JCheckBox reverseSequencesCb;

    public SequenceTranslationConfigurationPanel(boolean showJoinFramesCheckbox) {
        this.showJoinFramesCheckbox = showJoinFramesCheckbox;
        this.ncbiCodonTables = new NcbiCodonTables();
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel fixedFramePanel = new JPanel();
        fixedFramePanel.setLayout(new BoxLayout(fixedFramePanel, 0));
        this.fixedFrameRb = new JRadioButton("Starting at fixed frame", true);
        fixedFramePanel.add(this.fixedFrameRb);
        fixedFramePanel.add(Box.createHorizontalStrut(10));
        this.fixedFrameTf = new JIntegerTextField((Integer)1);
        fixedFramePanel.add(this.fixedFrameTf);
        this.fixedFrameTf.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SequenceTranslationConfigurationPanel.this.fixedFrameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SequenceTranslationConfigurationPanel.this.fixedFrameChanged();
            }
        });
        fixedFramePanel.add(Box.createHorizontalStrut(10));
        this.allFramesRb = new JRadioButton("Considering frames 1, 2 and 3");
        fixedFramePanel.add(this.allFramesRb);
        fixedFramePanel.add(Box.createHorizontalGlue());
        ButtonGroup framesButtonGroup = new ButtonGroup();
        framesButtonGroup.add(this.fixedFrameRb);
        framesButtonGroup.add(this.allFramesRb);
        this.allFramesRb.addItemListener(this::conversionConfigurationChanged);
        this.fixedFrameRb.addItemListener(this::conversionConfigurationChanged);
        JPanel joinFramesPanel = new JPanel();
        joinFramesPanel.setLayout(new BoxLayout(joinFramesPanel, 0));
        joinFramesPanel.add(Box.createHorizontalGlue());
        this.joinFramesCb = new JCheckBox("Join frames", false);
        joinFramesPanel.add(this.joinFramesCb);
        this.joinFramesCb.setEnabled(false);
        this.joinFramesCb.addItemListener(this::joinFramesChanged);
        JLabel joinFramesPanelInfo = new JLabel(Icons.ICON_INFO_2_16);
        joinFramesPanelInfo.setToolTipText(JOIN_FRAMES_INFO_LABEL);
        joinFramesPanel.add(Box.createHorizontalStrut(2));
        joinFramesPanel.add(joinFramesPanelInfo);
        JPanel customCodonTablePanel = new JPanel();
        customCodonTablePanel.setLayout(new BoxLayout(customCodonTablePanel, 0));
        this.predefinedCodonTableRb = new JRadioButton("Predefined", true);
        this.customCodonTableRb = new JRadioButton("Custom");
        ButtonGroup codonTableButtonGroup = new ButtonGroup();
        codonTableButtonGroup.add(this.customCodonTableRb);
        codonTableButtonGroup.add(this.predefinedCodonTableRb);
        this.customCodonTableRb.addItemListener(this::customCodonTableSelectionChanged);
        this.predefinedCodonTableRb.addItemListener(this::predefinedCodonTableSelectionChanged);
        this.predefinedCodonTableCombo = new ExtendedJComboBox();
        this.codonIdentifierToItemIndex = new HashMap<Integer, Integer>();
        int i = 0;
        for (ComboBoxItem<Integer> item : this.getPredefinedCodonTableItems()) {
            this.predefinedCodonTableCombo.addItem(item);
            this.codonIdentifierToItemIndex.put(item.getItem(), i++);
        }
        this.predefinedCodonTableCombo.setPreferredSize(new Dimension(150, 20));
        this.predefinedCodonTableCombo.setAutoAdjustWidth(true);
        this.predefinedCodonTableCombo.addItemListener(this::predefinedCodonTableSelectionChanged);
        JLabel customCodonTableInfo = new JLabel(Icons.ICON_INFO_2_16);
        customCodonTableInfo.setToolTipText(CUTOM_TABLE_INFO_LABEL);
        JLabel showCodonTable = new JLabel(Icons.ICON_LOOKUP_16);
        showCodonTable.setToolTipText(SHOW_CUTOM_TABLE_TOOLTIP);
        showCodonTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    e.consume();
                    JOptionPane.showMessageDialog(SequenceTranslationConfigurationPanel.this, new JScrollPane(new MapTableViewer(SequenceTranslationConfigurationPanel.this.getCodonTable())), "Codon table", -1);
                }
            }
        });
        customCodonTablePanel.add(new JLabel("Codon table: "));
        customCodonTablePanel.add(Box.createHorizontalStrut(10));
        customCodonTablePanel.add(this.predefinedCodonTableRb);
        customCodonTablePanel.add(Box.createHorizontalStrut(5));
        customCodonTablePanel.add(this.predefinedCodonTableCombo);
        customCodonTablePanel.add(Box.createHorizontalStrut(10));
        customCodonTablePanel.add(this.customCodonTableRb);
        customCodonTablePanel.add(Box.createHorizontalStrut(10));
        customCodonTablePanel.add(showCodonTable);
        customCodonTablePanel.add(Box.createHorizontalStrut(2));
        customCodonTablePanel.add(customCodonTableInfo);
        customCodonTablePanel.add(Box.createHorizontalGlue());
        fixedFramePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JPanel reverseSequencesPanel = new JPanel();
        reverseSequencesPanel.setLayout(new BoxLayout(reverseSequencesPanel, 0));
        this.reverseSequencesCb = new JCheckBox("Use reverse complement sequences ", false);
        this.reverseSequencesCb.addItemListener(this::reverseSequencesChanged);
        JLabel reverseSequencesInfo = new JLabel(Icons.ICON_INFO_2_16);
        reverseSequencesInfo.setToolTipText(REVERSE_SEQUENCES_INFO_LABEL);
        reverseSequencesPanel.add(this.reverseSequencesCb);
        reverseSequencesPanel.add(reverseSequencesInfo);
        reverseSequencesPanel.add(Box.createHorizontalGlue());
        this.add(fixedFramePanel);
        if (this.showJoinFramesCheckbox) {
            this.add(joinFramesPanel);
        }
        this.add(customCodonTablePanel);
        this.add(reverseSequencesPanel);
    }

    private List<ComboBoxItem<Integer>> getPredefinedCodonTableItems() {
        LinkedList<ComboBoxItem<Integer>> items = new LinkedList<ComboBoxItem<Integer>>();
        this.ncbiCodonTables.listTables().forEach((k, v) -> items.add(new ComboBoxItem<Integer>((Integer)k, (String)v)));
        return items;
    }

    private void loadCustomMap(File file) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.customCodonTable = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            this.customCodonTable.put(name, properties.getProperty(name));
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (!this.ignoreGuiEvents) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void predefinedCodonTableSelectionChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.firePropertyChange(PROPERTY_CODON_TABLE, null, this.getCodonTable());
        }
    }

    private void customCodonTableSelectionChanged(ItemEvent event) {
        if (event.getStateChange() == 1 && !this.ignoreGuiEvents) {
            JFileChooser fileChooser = CommonFileChooser.getInstance().getFilechooser();
            int selection = fileChooser.showSaveDialog(this);
            if (selection == 0) {
                if (fileChooser.getSelectedFile() != null) {
                    this.loadCustomMap(fileChooser.getSelectedFile());
                } else {
                    this.customCodonTable.clear();
                }
                this.firePropertyChange(PROPERTY_CODON_TABLE, null, this.getCodonTable());
            } else {
                this.predefinedCodonTableRb.setSelected(true);
            }
        }
    }

    private void joinFramesChanged(ItemEvent event) {
        this.firePropertyChange(PROPERTY_JOIN_FRAMES, null, (Object)this.joinFramesCb.isSelected());
    }

    private void reverseSequencesChanged(ItemEvent event) {
        this.firePropertyChange(PROPERTY_REVERSE_SEQUENCES, null, (Object)this.reverseSequencesCb.isSelected());
    }

    private void conversionConfigurationChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.fixedFrameTf.setEnabled(this.fixedFrameRb.isSelected());
            this.joinFramesCb.setEnabled(!this.fixedFrameRb.isSelected());
            this.firePropertyChange(PROPERTY_FRAMES, null, this.getTranslationFrames());
        }
    }

    private void fixedFrameChanged() {
        try {
            this.fixedFrameTf.commitEdit();
            if (this.isValidFixedFrame()) {
                this.fixedFrameTf.setBackground(null);
            } else {
                this.fixedFrameTf.setBackground(GuiUtils.COLOR_ERROR);
            }
            this.firePropertyChange(PROPERTY_FRAMES, null, this.getTranslationFrames());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private boolean isJoinFrames() {
        return this.joinFramesCb.isSelected() && !this.fixedFrameRb.isSelected();
    }

    private boolean isReverseSequences() {
        return this.reverseSequencesCb.isSelected();
    }

    private int[] getTranslationFrames() {
        if (this.fixedFrameRb.isSelected()) {
            return new int[]{this.fixedFrameTf.getValue()};
        }
        return new int[]{1, 2, 3};
    }

    private Map<String, String> getCodonTable() {
        return this.customCodonTableRb.isSelected() ? this.customCodonTable : this.getPrefedinedTable();
    }

    private Map<String, String> getPrefedinedTable() {
        Integer id = (Integer)((ComboBoxItem)this.predefinedCodonTableCombo.getSelectedItem()).getItem();
        return this.ncbiCodonTables.getCodonTable(id);
    }

    public boolean isValidUserSelection() {
        return this.isTranslationConfigurationValid();
    }

    private boolean isTranslationConfigurationValid() {
        return (this.allFramesRb.isSelected() || this.isValidFixedFrame()) && this.isCustomCodonTableConfigurationValid();
    }

    private boolean isCustomCodonTableConfigurationValid() {
        return !this.customCodonTableRb.isSelected() || !this.customCodonTable.isEmpty();
    }

    private boolean isValidFixedFrame() {
        int fixedFrame = this.fixedFrameTf.getValue();
        return fixedFrame > 0 && fixedFrame < 4;
    }

    public void enableControls(boolean enabled) {
        this.allFramesRb.setEnabled(enabled);
        this.fixedFrameRb.setEnabled(enabled);
        this.fixedFrameTf.setEnabled(enabled);
        this.customCodonTableRb.setEnabled(enabled);
        this.joinFramesCb.setEnabled(enabled && this.allFramesRb.isSelected());
        this.reverseSequencesCb.setEnabled(enabled);
    }

    public SequenceTranslationConfiguration getSequenceTranslationConfiguration() {
        if (!this.showJoinFramesCheckbox) {
            return new SequenceTranslationConfiguration(this.getCodonTable(), this.isReverseSequences(), this.getTranslationFrames());
        }
        return new SequenceTranslationConfiguration(this.getCodonTable(), this.isReverseSequences(), this.isJoinFrames(), this.getTranslationFrames());
    }

    public void setSequenceTranslationConfiguration(SequenceTranslationConfiguration configuration) {
        this.ignoreGuiEvents = true;
        this.joinFramesCb.setSelected(configuration.isJoinFrames());
        if (configuration.getFrames().size() == 1) {
            this.fixedFrameRb.setSelected(true);
            this.fixedFrameTf.setValue(configuration.getFrames().get(0));
        } else {
            this.allFramesRb.setSelected(true);
        }
        this.reverseSequencesCb.setSelected(configuration.isReverseComplement());
        Optional<Integer> codonTableId = this.ncbiCodonTables.findIdentifier(configuration.getCodonTable());
        if (codonTableId.isPresent()) {
            this.predefinedCodonTableRb.setSelected(true);
            this.predefinedCodonTableCombo.setSelectedIndex(this.codonIdentifierToItemIndex.get(codonTableId.get()));
        } else {
            this.customCodonTableRb.setSelected(true);
            this.customCodonTable = configuration.getCodonTable();
        }
        this.ignoreGuiEvents = false;
    }
}

