/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.rename;

import java.awt.event.ItemEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.list.JInputList;
import org.sing_group.gc4s.input.list.event.DefaultListDataListener;
import org.sing_group.seda.core.rename.HeaderRenamer;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.core.rename.WordReplaceRenamer;
import org.sing_group.seda.gui.configuration_panel.rename.AbstractRenameHeaderPanel;
import org.sing_group.seda.plugin.core.info.plugin.RenameHeaderReplaceWordSedaPluginInfo;

public class WordReplaceRenamePanel
extends AbstractRenameHeaderPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox isRegexCheckBox;
    private JXTextField replacementTextField;
    private JInputList targetsListPanel;

    public WordReplaceRenamePanel() {
        this.init();
    }

    private void init() {
        this.add(new InputParametersPanel(this.getParameters()));
    }

    private InputParameter[] getParameters() {
        InputParameter[] toret = new InputParameter[]{this.getTargetsParameter(), this.getIsRegexParameter(), this.getReplacementParameter()};
        return toret;
    }

    private boolean isValidRegex(String regex) {
        try {
            Pattern.compile(regex);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    private InputParameter getTargetsParameter() {
        this.targetsListPanel = new JInputList(true, false, false){
            private static final long serialVersionUID = 1L;

            @Override
            protected void addElement() {
                if (WordReplaceRenamePanel.this.isRegex()) {
                    String currentPatternToAdd = this.getElementToAdd();
                    if (WordReplaceRenamePanel.this.isValidRegex(currentPatternToAdd)) {
                        super.addElement();
                    } else {
                        WordReplaceRenamePanel.this.showRegexPatternWarning(currentPatternToAdd);
                    }
                } else {
                    super.addElement();
                }
            }
        };
        this.targetsListPanel.setElementIntroductionEnabled(true);
        this.targetsListPanel.getListPanel().getBtnMoveDown().setVisible(false);
        this.targetsListPanel.getListPanel().getBtnMoveUp().setVisible(false);
        this.targetsListPanel.addListDataListener(new DefaultListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                WordReplaceRenamePanel.this.renameConfigurationChanged();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                WordReplaceRenamePanel.this.renameConfigurationChanged();
            }
        });
        return new InputParameter("Targets", this.targetsListPanel, RenameHeaderReplaceWordSedaPluginInfo.PARAM_TARGET_WORDS_HELP_GUI);
    }

    private InputParameter getIsRegexParameter() {
        this.isRegexCheckBox = new JCheckBox("Regex");
        this.isRegexCheckBox.addItemListener(this::regexChanged);
        return new InputParameter("", this.isRegexCheckBox, RenameHeaderReplaceWordSedaPluginInfo.PARAM_REGEX_HELP_GUI);
    }

    private void regexChanged(ItemEvent event) {
        SwingUtilities.invokeLater(() -> {
            this.checkPatternsList();
            this.renameConfigurationChanged();
        });
    }

    private void checkPatternsList() {
        LinkedList<String> newTargets = new LinkedList<String>();
        LinkedList<String> invalidTargets = new LinkedList<String>();
        for (String target : this.getTargets()) {
            if (!this.isValidRegex(target)) {
                invalidTargets.add(target);
                continue;
            }
            newTargets.add(target);
        }
        if (!invalidTargets.isEmpty()) {
            this.targetsListPanel.removeAllElements();
            this.targetsListPanel.addElements(newTargets.toArray(new String[newTargets.size()]));
            JOptionPane.showMessageDialog(this, "The following targets were not valid regular expressions and have been removed: " + invalidTargets.stream().collect(Collectors.joining(", ")), "Regular expression check", 2);
        }
    }

    private InputParameter getReplacementParameter() {
        this.replacementTextField = new JXTextField("Replacement");
        this.replacementTextField.getDocument().addDocumentListener(this.documentListener);
        return new InputParameter("Replacement", this.replacementTextField, RenameHeaderReplaceWordSedaPluginInfo.PARAM_REPLACEMENT_HELP_GUI);
    }

    private List<String> getTargets() {
        return this.targetsListPanel.getInputItems();
    }

    private boolean isRegex() {
        return this.isRegexCheckBox.isSelected();
    }

    private String getReplacement() {
        return this.replacementTextField.getText();
    }

    @Override
    public boolean isValidConfiguration() {
        return !this.getTargets().isEmpty();
    }

    @Override
    public HeaderRenamer getHeaderRenamer(HeaderTarget target) {
        return new WordReplaceRenamer(target, this.getReplacement(), this.isRegex(), this.getTargets());
    }

    public void setHeaderRenamer(WordReplaceRenamer renamer) {
        this.isRegexCheckBox.setSelected(renamer.isRegex());
        this.replacementTextField.setText(renamer.getReplacement());
        this.targetsListPanel.removeAllElements();
        this.targetsListPanel.addElements(renamer.getTargets().toArray(new String[renamer.getTargets().size()]));
    }

    private void showRegexPatternWarning(String regex) {
        JOptionPane.showMessageDialog(this, regex + " is not a valid regular expression.", "Regular expression error", 0);
    }
}

