/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.ncbi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.seda.plugin.core.info.plugin.NcbiRenameSedaPluginInfo;
import org.sing_group.seda.transformation.dataset.MapRenameSequencesGroupDatasetTransformation;

public class SequenceHeaderRenameConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_POSITION = "seda.sequenceheaderrenameconfiguration.position";
    public static final String PROPERTY_DELIMITER = "seda.sequenceheaderconfiguration.delimiter";
    public static final String PROPERTY_ADD_INDEX = "seda.sequenceheaderconfiguration.addindex";
    public static final String PROPERTY_INDEX_DELIMITER = "seda.sequenceheaderconfiguration.indexdelimiter";
    private static final String HELP_POSITION = NcbiRenameSedaPluginInfo.PARAM_HEADER_POSITION_HELP_GUI;
    private static final String HELP_DELIMITER = NcbiRenameSedaPluginInfo.PARAM_HEADER_DELIMITER_HELP_GUI;
    private static final String HELP_INDEX = NcbiRenameSedaPluginInfo.PARAM_HEADER_INDEX_HELP_GUI;
    private static final String HELP_INDEX_DELIMITER = NcbiRenameSedaPluginInfo.PARAM_HEADER_INDEX_DELIMITER_HELP_GUI;
    private JComboBox<MapRenameSequencesGroupDatasetTransformation.RenameMode> positionCombo;
    private JXTextField delimiterTextField;
    private JCheckBox addIndexCheckbox;
    private JXTextField indexDelimiterTextField;

    public SequenceHeaderRenameConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getParametersPanel(), "Center");
    }

    private Component getParametersPanel() {
        return new InputParametersPanel(this.getParameters());
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getPositionParameter());
        parameters.add(this.getDelimiterParameter());
        parameters.add(this.getAddIndexParameter());
        parameters.add(this.getIndexDelimiterParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getPositionParameter() {
        this.positionCombo = new JComboBox<MapRenameSequencesGroupDatasetTransformation.RenameMode>(this.getRenameModeValues());
        this.positionCombo.addItemListener(this::positionChanged);
        return new InputParameter("Position:", this.positionCombo, HELP_POSITION);
    }

    private MapRenameSequencesGroupDatasetTransformation.RenameMode[] getRenameModeValues() {
        LinkedList<MapRenameSequencesGroupDatasetTransformation.RenameMode> renameModes = new LinkedList<MapRenameSequencesGroupDatasetTransformation.RenameMode>(Arrays.asList(MapRenameSequencesGroupDatasetTransformation.RenameMode.values()));
        renameModes.remove((Object)MapRenameSequencesGroupDatasetTransformation.RenameMode.REPLACE);
        return renameModes.toArray(new MapRenameSequencesGroupDatasetTransformation.RenameMode[renameModes.size()]);
    }

    private void positionChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.firePropertyChange(PROPERTY_POSITION, null, (Object)this.getPosition());
        }
    }

    public MapRenameSequencesGroupDatasetTransformation.RenameMode getPosition() {
        return (MapRenameSequencesGroupDatasetTransformation.RenameMode)((Object)this.positionCombo.getSelectedItem());
    }

    private InputParameter getDelimiterParameter() {
        this.delimiterTextField = new JXTextField("Delimiter");
        this.delimiterTextField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            private void documentChanged() {
                SwingUtilities.invokeLater(() -> SequenceHeaderRenameConfigurationPanel.this.delimiterChanged());
            }
        });
        return new InputParameter("Delimiter:", this.delimiterTextField, HELP_DELIMITER);
    }

    private void delimiterChanged() {
        this.firePropertyChange(PROPERTY_DELIMITER, null, this.getDelimiter());
    }

    public String getDelimiter() {
        return this.delimiterTextField.getText();
    }

    private InputParameter getAddIndexParameter() {
        this.addIndexCheckbox = new JCheckBox();
        this.addIndexCheckbox.addItemListener(this::addIndexChanged);
        return new InputParameter("Add index:", this.addIndexCheckbox, HELP_INDEX);
    }

    private void addIndexChanged(ItemEvent event) {
        this.firePropertyChange(PROPERTY_ADD_INDEX, null, (Object)this.isAddIndex());
    }

    public boolean isAddIndex() {
        return this.addIndexCheckbox.isSelected();
    }

    private InputParameter getIndexDelimiterParameter() {
        this.indexDelimiterTextField = new JXTextField("Index delimiter");
        this.indexDelimiterTextField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            private void documentChanged() {
                SwingUtilities.invokeLater(() -> SequenceHeaderRenameConfigurationPanel.this.indexDelimiterChanged());
            }
        });
        return new InputParameter("Index delimiter:", this.indexDelimiterTextField, HELP_INDEX_DELIMITER);
    }

    private void indexDelimiterChanged() {
        this.firePropertyChange(PROPERTY_INDEX_DELIMITER, null, this.getIndexDelimiter());
    }

    public String getIndexDelimiter() {
        return this.indexDelimiterTextField.getText();
    }

    public void setPosition(MapRenameSequencesGroupDatasetTransformation.RenameMode newPosition) {
        this.positionCombo.setSelectedItem((Object)newPosition);
    }

    public void setDelimiter(String newDelimiter) {
        this.delimiterTextField.setText(newDelimiter);
    }

    public void setAddIndex(boolean newAddIndex) {
        this.addIndexCheckbox.setSelected(newAddIndex);
    }

    public void setIndexDelimiter(String newIndexDelimiter) {
        this.indexDelimiterTextField.setText(newIndexDelimiter);
    }
}

