/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.ncbi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.InvalidClassException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListDataEvent;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.event.ListDataAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.list.ExtendedDefaultListModel;
import org.sing_group.gc4s.input.list.JParallelListsPanel;
import org.sing_group.seda.core.ncbi.NcbiTaxonomyFields;
import org.sing_group.seda.plugin.core.info.plugin.NcbiRenameSedaPluginInfo;

public class NcbiTaxonomyConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_DELIMITER = "seda.taxonomyconfiguration.delimiter";
    public static final String PROPERTY_FIELDS = "seda.taxonomyconfiguration.fields";
    private static final String HELP_DELIMITER = NcbiRenameSedaPluginInfo.PARAM_NCBI_DELIMITER_HELP_GUI;
    private static final String HELP_FIELDS = NcbiRenameSedaPluginInfo.PARAM_NCBI_FIELDS_HELP_GUI;
    private JXTextField delimiterTextField;
    private JParallelListsPanel<NcbiTaxonomyFields> parallelLists;
    private JList<NcbiTaxonomyFields> selectedElementsList;

    public NcbiTaxonomyConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getParametersPanel(), "Center");
    }

    private Component getParametersPanel() {
        return new InputParametersPanel(this.getParameters());
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getDelimiterParameter());
        parameters.add(this.getFieldsParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getDelimiterParameter() {
        this.delimiterTextField = new JXTextField("Delimiter");
        this.delimiterTextField.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            private void documentChanged() {
                SwingUtilities.invokeLater(() -> NcbiTaxonomyConfigurationPanel.this.delimiterChanged());
            }
        });
        return new InputParameter("Delimiter:", this.delimiterTextField, HELP_DELIMITER);
    }

    private void delimiterChanged() {
        this.firePropertyChange(PROPERTY_DELIMITER, null, this.getDelimiter());
    }

    public String getDelimiter() {
        return this.delimiterTextField.getText();
    }

    private InputParameter getFieldsParameter() {
        try {
            this.parallelLists = new JParallelListsPanel<NcbiTaxonomyFields>(this.createLeftList(), this.createRightList(), "Unselected", "Selected", true, false);
            this.parallelLists.getLeftListPanel().getBtnRemoveElements().setVisible(false);
            this.parallelLists.getRightListPanel().getBtnRemoveElements().setVisible(false);
            return new InputParameter("Fields:", this.parallelLists, HELP_FIELDS);
        }
        catch (InvalidClassException e) {
            throw new RuntimeException();
        }
    }

    private JList<NcbiTaxonomyFields> createLeftList() {
        return NcbiTaxonomyConfigurationPanel.createList(Arrays.asList(NcbiTaxonomyFields.values()));
    }

    private JList<NcbiTaxonomyFields> createRightList() {
        this.selectedElementsList = NcbiTaxonomyConfigurationPanel.createList(Collections.emptyList());
        this.selectedElementsList.getModel().addListDataListener(new ListDataAdapter(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.listChanged();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.listChanged();
            }

            private void listChanged() {
                SwingUtilities.invokeLater(() -> NcbiTaxonomyConfigurationPanel.this.selectedElementsListChanged());
            }
        });
        return this.selectedElementsList;
    }

    private static JList<NcbiTaxonomyFields> createList(List<NcbiTaxonomyFields> data) {
        ExtendedDefaultListModel<NcbiTaxonomyFields> listModel = new ExtendedDefaultListModel<NcbiTaxonomyFields>();
        listModel.addElements(data);
        return new JList<NcbiTaxonomyFields>(listModel);
    }

    private void selectedElementsListChanged() {
        this.firePropertyChange(PROPERTY_FIELDS, null, this.getFields());
    }

    public List<NcbiTaxonomyFields> getFields() {
        LinkedList<NcbiTaxonomyFields> selectedFields = new LinkedList<NcbiTaxonomyFields>();
        ListModel<NcbiTaxonomyFields> model = this.selectedElementsList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            selectedFields.add(model.getElementAt(i));
        }
        return selectedFields;
    }

    public void setDelimiter(String newNcbiTaxonomyDelimiter) {
        this.delimiterTextField.setText(newNcbiTaxonomyDelimiter);
    }

    public void setFields(List<NcbiTaxonomyFields> ncbiTaxonomyFields) {
        this.parallelLists.setRightListElements(ncbiTaxonomyFields);
    }
}

