/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.filtering.header;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.input.text.IntegerRangeInputPanel;
import org.sing_group.gc4s.ui.Orientation;
import org.sing_group.seda.core.filtering.HeaderFilteringConfiguration;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.gui.configuration_panel.filtering.header.RegexHeaderMatcherConfigurationPanel;
import org.sing_group.seda.plugin.core.info.common.HeaderCountFilteringInfo;

public class HeaderFilteringConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_FILTER_CONFIGURATION = "filtering.configuration";
    private static final String HELP_RANGE = "The minimum and maximum number of sequences that must contain the specified filter.";
    private static final String HELP_FILTER_TYPE = HeaderCountFilteringInfo.PARAM_HEADER_FILTER_HELP_GUI;
    private static final String HELP_REGEX_MATCHER = "The regular expression configuration to match the sequence headers that must be concatenated. Check the manual for examples of regular expressions.";
    private HeaderFilteringConfiguration oldValue;
    private JXTaskPane translationConfigurationTaskPane;
    private JCheckBox useFilter;
    private RadioButtonsPanel<HeaderFilteringConfiguration.Mode> modeRbtn;
    private RadioButtonsPanel<HeaderFilteringConfiguration.Level> levelRbtn;
    private IntegerRangeInputPanel rangePanel;
    private RadioButtonsPanel<HeaderFilteringConfiguration.FilterType> filterTypeRbtn;
    private RegexHeaderMatcherConfigurationPanel regexHeaderMatcherConfiguration;

    public HeaderFilteringConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getUseFilterCombobox(), "North");
        this.add((Component)this.getCenterPanel(), "Center");
    }

    private Component getUseFilterCombobox() {
        this.useFilter = new JCheckBox("Use this filter", false);
        this.useFilter.addItemListener(this::useFilterChanged);
        return this.useFilter;
    }

    private void useFilterChanged(ItemEvent event) {
        this.translationConfigurationTaskPane.setCollapsed(!this.isUseFilterSelected());
        this.configurationChanged();
    }

    private boolean isUseFilterSelected() {
        return this.useFilter.isSelected();
    }

    private JComponent getCenterPanel() {
        JXTaskPaneContainer customOptionsTaskPaneContainer = new JXTaskPaneContainer();
        customOptionsTaskPaneContainer.setOpaque(false);
        customOptionsTaskPaneContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.translationConfigurationTaskPane = new JXTaskPane();
        this.translationConfigurationTaskPane.setTitle("Configuration");
        this.translationConfigurationTaskPane.add(this.getInputParametersPanel());
        this.translationConfigurationTaskPane.setCollapsed(true);
        customOptionsTaskPaneContainer.add(this.translationConfigurationTaskPane);
        return customOptionsTaskPaneContainer;
    }

    private Component getInputParametersPanel() {
        return new InputParametersPanel(this.getInputParameters());
    }

    private InputParameter[] getInputParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getModeParameter());
        parameters.add(this.getLevelParameter());
        parameters.add(this.getRangeParameter());
        parameters.add(this.getFilterTypeParameter());
        parameters.add(this.getStringParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getModeParameter() {
        this.modeRbtn = new RadioButtonsPanel<HeaderFilteringConfiguration.Mode>(HeaderFilteringConfiguration.Mode.values(), 1, 0);
        this.modeRbtn.addItemListener(this::itemEventListener);
        return new InputParameter("Mode: ", this.modeRbtn, HeaderCountFilteringInfo.PARAM_HEADER_MODE_HELP_GUI);
    }

    private InputParameter getLevelParameter() {
        this.levelRbtn = new RadioButtonsPanel<HeaderFilteringConfiguration.Level>(HeaderFilteringConfiguration.Level.values(), 1, 0);
        this.levelRbtn.addItemListener(this::itemEventListener);
        return new InputParameter("Level: ", this.levelRbtn, HeaderCountFilteringInfo.PARAM_HEADER_LEVEL_HELP_GUI);
    }

    private void itemEventListener(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.configurationChanged();
        }
    }

    private InputParameter getRangeParameter() {
        this.rangePanel = new IntegerRangeInputPanel(0, 10, "Min.:", "Max.:", Orientation.HORIZONTAL);
        this.rangePanel.addChangeListener(this::rangeChanged);
        return new InputParameter("Range: ", this.rangePanel, HELP_RANGE);
    }

    private void rangeChanged(ChangeEvent event) {
        this.configurationChanged();
    }

    private InputParameter getFilterTypeParameter() {
        this.filterTypeRbtn = new RadioButtonsPanel<HeaderFilteringConfiguration.FilterType>(HeaderFilteringConfiguration.FilterType.values(), 1, 0);
        this.filterTypeRbtn.addItemListener(this::filterTypeChanged);
        return new InputParameter("Filter type: ", this.filterTypeRbtn, HELP_FILTER_TYPE);
    }

    private void filterTypeChanged(ItemEvent event) {
        this.checkStringComponent();
        this.itemEventListener(event);
    }

    private InputParameter getStringParameter() {
        this.regexHeaderMatcherConfiguration = new RegexHeaderMatcherConfigurationPanel();
        this.regexHeaderMatcherConfiguration.setBorder(BorderFactory.createTitledBorder("Header matcher configuration"));
        this.checkStringComponent();
        this.regexHeaderMatcherConfiguration.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (RegexHeaderMatcherConfigurationPanel.PROPERTIES.contains(evt.getPropertyName())) {
                    HeaderFilteringConfigurationPanel.this.configurationChanged();
                }
            }
        });
        return new InputParameter("", this.regexHeaderMatcherConfiguration, HELP_REGEX_MATCHER);
    }

    private void checkStringComponent() {
        SwingUtilities.invokeLater(() -> {
            boolean enabled = this.getFilterType().equals((Object)HeaderFilteringConfiguration.FilterType.REGEX);
            this.regexHeaderMatcherConfiguration.setInputControlsEnabled(enabled);
        });
    }

    private HeaderFilteringConfiguration.FilterType getFilterType() {
        return this.filterTypeRbtn.getSelectedItem().get();
    }

    private void configurationChanged() {
        SwingUtilities.invokeLater(() -> {
            HeaderFilteringConfiguration newValue = this.getHeaderFilteringConfiguration();
            this.firePropertyChange(PROPERTY_FILTER_CONFIGURATION, this.oldValue, newValue);
            this.oldValue = newValue;
        });
    }

    public HeaderFilteringConfiguration getHeaderFilteringConfiguration() {
        return new HeaderFilteringConfiguration(this.isUseFilterSelected(), this.modeRbtn.getSelectedItem().get(), this.levelRbtn.getSelectedItem().get(), this.rangePanel.getMinValue(), this.rangePanel.getMaxValue(), this.getFilterType(), this.regexHeaderMatcherConfiguration.getString(), this.regexHeaderMatcherConfiguration.isQuotePattern(), this.getRegexGroup(), this.regexHeaderMatcherConfiguration.isCaseSensitive(), this.getHeaderTarget());
    }

    private HeaderTarget getHeaderTarget() {
        return this.regexHeaderMatcherConfiguration.getHeaderTarget();
    }

    private int getRegexGroup() {
        return this.regexHeaderMatcherConfiguration.getRegexGroup();
    }

    public void setHeaderFilteringConfiguration(HeaderFilteringConfiguration headerFilteringConfiguration) {
        if (!headerFilteringConfiguration.equals(this.getHeaderFilteringConfiguration())) {
            this.useFilter.setSelected(headerFilteringConfiguration.isUseFilter());
            if (headerFilteringConfiguration.getMode() != null) {
                this.modeRbtn.setSelectedItem(headerFilteringConfiguration.getMode());
            }
            if (headerFilteringConfiguration.getLevel() != null) {
                this.levelRbtn.setSelectedItem(headerFilteringConfiguration.getLevel());
            }
            if (headerFilteringConfiguration.getFilterType() != null) {
                this.filterTypeRbtn.setSelectedItem(headerFilteringConfiguration.getFilterType());
            }
            this.rangePanel.setMinValue(headerFilteringConfiguration.getMin());
            this.rangePanel.setMaxValue(headerFilteringConfiguration.getMax());
            this.regexHeaderMatcherConfiguration.setHeaderTarget(headerFilteringConfiguration.getHeaderTarget());
            this.regexHeaderMatcherConfiguration.setString(headerFilteringConfiguration.getFilterString());
            this.regexHeaderMatcherConfiguration.setQuotePattern(headerFilteringConfiguration.isQuotePattern());
            this.regexHeaderMatcherConfiguration.setCaseSensitive(headerFilteringConfiguration.isCaseSensitive());
            this.regexHeaderMatcherConfiguration.setRegexGroup(headerFilteringConfiguration.getRegexGroup());
            this.configurationChanged();
        }
    }
}

