/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.datatype.SequenceCase;
import org.sing_group.seda.gui.GuiUtils;
import org.sing_group.seda.io.LineBreakType;
import org.sing_group.seda.plugin.core.info.plugin.ReformatFastaSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationChangeEvent;
import org.sing_group.seda.plugin.spi.TransformationChangeListener;
import org.sing_group.seda.transformation.provider.reformat.ReformatConfigurationChangeType;
import org.sing_group.seda.transformation.provider.reformat.ReformatFastaTransformationProvider;

public class ReformatFastaConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TransformationChangeListener transformationChangeListener = new TransformationChangeListener(){

        @Override
        public void onTransformationChange(TransformationChangeEvent event) {
            ReformatFastaConfigurationPanel.this.modelChanged(event);
        }
    };
    private ReformatFastaTransformationProvider transformationProvider = new ReformatFastaTransformationProvider();
    private JIntegerTextField fragmentLength;
    private JCheckBox removeLineBreaks;
    private RadioButtonsPanel<LineBreakType> lineBreakTypeRbtn;
    private RadioButtonsPanel<SequenceCase> sequenceCaseRbtn;

    public ReformatFastaConfigurationPanel() {
        this.init();
        this.bindGuiControls();
        this.transformationProvider.addTransformationChangeListener(this.transformationChangeListener);
    }

    private void bindGuiControls() {
        GuiUtils.bindIntegerTextField(this.fragmentLength, this.transformationProvider::setFragmentLength);
        GuiUtils.bindCheckBox(this.removeLineBreaks, this.transformationProvider::setRemoveLineBreaks);
        GuiUtils.bindRadioButtonsPanel(this.lineBreakTypeRbtn, this.transformationProvider::setLineBreakType);
        GuiUtils.bindRadioButtonsPanel(this.sequenceCaseRbtn, this.transformationProvider::setSequenceCase);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        InputParametersPanel mainPanel = new InputParametersPanel(this.getParameters());
        return new CenteredJPanel(mainPanel);
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getFragmentLengthParameter());
        parameters.add(this.getRemoveLineBreaksParameter());
        parameters.add(this.getLineBreakTypeParameter());
        parameters.add(this.getSequenceCaseParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getFragmentLengthParameter() {
        this.fragmentLength = new JIntegerTextField((Integer)this.transformationProvider.getFragmentLength());
        return new InputParameter("Fragment length:", this.fragmentLength, ReformatFastaSedaPluginInfo.PARAM_FRAGMENT_LENGHT_HELP_GUI);
    }

    private InputParameter getRemoveLineBreaksParameter() {
        this.removeLineBreaks = new JCheckBox("Remove line breaks", this.transformationProvider.isRemoveLineBreaks());
        return new InputParameter("", this.removeLineBreaks, ReformatFastaSedaPluginInfo.PARAM_REMOVE_LINE_BREAKS_HELP_GUI);
    }

    private InputParameter getLineBreakTypeParameter() {
        this.lineBreakTypeRbtn = new RadioButtonsPanel<LineBreakType>(LineBreakType.values(), 1, 0);
        this.lineBreakTypeRbtn.setSelectedItem(this.transformationProvider.getLineBreakType());
        return new InputParameter("Line breaks:", this.lineBreakTypeRbtn, ReformatFastaSedaPluginInfo.PARAM_LINE_BREAKS_HELP_GUI);
    }

    private InputParameter getSequenceCaseParameter() {
        this.sequenceCaseRbtn = new RadioButtonsPanel<SequenceCase>(SequenceCase.values());
        this.sequenceCaseRbtn.setSelectedItem(this.transformationProvider.getSequenceCase());
        return new InputParameter("Case:", this.sequenceCaseRbtn, ReformatFastaSedaPluginInfo.PARAM_SEQUENCE_CASE_HELP_GUI);
    }

    private void modelChanged(TransformationChangeEvent event) {
        SwingUtilities.invokeLater(() -> {
            switch ((ReformatConfigurationChangeType)event.getType()) {
                case FRAGMENT_LENGTH_CHANGED: {
                    this.updateFragmentLength();
                    break;
                }
                case REMOVE_LINE_BREAKS_CHANGED: {
                    this.updateRemoveLineBreaks();
                    break;
                }
                case LINE_BREAK_TYPE_CHANGED: {
                    this.updateLineBreakType();
                    break;
                }
                case SEQUENCE_CASE_CHANGED: {
                    this.updateSequenceCase();
                }
            }
        });
    }

    private void updateFragmentLength() {
        this.fragmentLength.setValue(this.transformationProvider.getFragmentLength());
    }

    private void updateRemoveLineBreaks() {
        this.removeLineBreaks.setSelected(this.transformationProvider.isRemoveLineBreaks());
        this.fragmentLength.setEditable(!this.transformationProvider.isRemoveLineBreaks());
    }

    private void updateLineBreakType() {
        this.lineBreakTypeRbtn.setSelectedItem(this.transformationProvider.getLineBreakType());
    }

    private void updateSequenceCase() {
        this.sequenceCaseRbtn.setSelectedItem(this.transformationProvider.getSequenceCase());
    }

    public ReformatFastaTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(ReformatFastaTransformationProvider transformationProvider) {
        this.transformationProvider.removeTranformationChangeListener(this.transformationChangeListener);
        this.transformationProvider = transformationProvider;
        this.bindGuiControls();
        this.transformationProvider.addTransformationChangeListener(this.transformationChangeListener);
        this.updateFragmentLength();
        this.updateRemoveLineBreaks();
        this.updateLineBreakType();
        this.updateSequenceCase();
    }
}

