/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import javax.swing.JPanel;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.plugin.core.info.plugin.DisambiguateSequenceNamesSedaPluginInfo;
import org.sing_group.seda.transformation.provider.disambiguate.DisambiguateSequenceNamesTransformationProvider;
import org.sing_group.seda.transformation.sequencesgroup.DisambiguateSequenceNamesTransformation;

public class DisambiguateSequenceNamesConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DisambiguateSequenceNamesTransformationProvider transformationProvider;
    private RadioButtonsPanel<DisambiguateSequenceNamesTransformation.Mode> modeRadioButtons;

    public DisambiguateSequenceNamesConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        InputParametersPanel mainPanel = new InputParametersPanel(this.getParameters());
        return new CenteredJPanel(mainPanel);
    }

    private InputParameter[] getParameters() {
        InputParameter[] parameters = new InputParameter[]{this.getModeParameter()};
        return parameters;
    }

    private InputParameter getModeParameter() {
        this.modeRadioButtons = new RadioButtonsPanel<DisambiguateSequenceNamesTransformation.Mode>(DisambiguateSequenceNamesTransformation.Mode.values(), 1, 2);
        this.modeRadioButtons.addItemListener(this::modeChanged);
        return new InputParameter("Disambiguation mode: ", this.modeRadioButtons, DisambiguateSequenceNamesSedaPluginInfo.PARAM_MODE_HELP_GUI);
    }

    private void modeChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.transformationProvider.setMode(this.getSelectedMode());
        }
    }

    private DisambiguateSequenceNamesTransformation.Mode getSelectedMode() {
        return this.modeRadioButtons.getSelectedItem().get();
    }

    private void initTransformationProvider() {
        this.transformationProvider = new DisambiguateSequenceNamesTransformationProvider();
        this.transformationProvider.setMode(this.getSelectedMode());
    }

    public DisambiguateSequenceNamesTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(DisambiguateSequenceNamesTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        this.modeRadioButtons.setSelectedItem(transformationProvider.getMode());
    }
}

