/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.sing_group.gc4s.dialog.JOptionPaneMessage;
import org.sing_group.gc4s.input.tree.JTreeSelectionPanel;
import org.sing_group.gc4s.input.tree.PathCheckTreeSelectionModel;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.gc4s.ui.icons.Icons;
import org.sing_group.gc4s.ui.menu.HamburgerMenu;
import org.sing_group.gc4s.utilities.ExtendedAbstractAction;
import org.sing_group.gc4s.utilities.JTreeUtils;
import org.sing_group.seda.core.SedaContext;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.CustomSwingWorker;
import org.sing_group.seda.gui.GuiUtils;
import org.sing_group.seda.gui.HtmlMessage;
import org.sing_group.seda.gui.OutputConfigurationModel;
import org.sing_group.seda.gui.OutputConfigurationModelEvent;
import org.sing_group.seda.gui.OutputConfigurationPanel;
import org.sing_group.seda.gui.PathSelectionModel;
import org.sing_group.seda.gui.SelectionPanel;
import org.sing_group.seda.gui.WorkingDialog;
import org.sing_group.seda.io.DatasetProcessor;
import org.sing_group.seda.io.DatasetProcessorConfiguration;
import org.sing_group.seda.plugin.SedaPluginManager;
import org.sing_group.seda.plugin.spi.SedaGuiPlugin;
import org.sing_group.seda.plugin.spi.SedaPluginFactory;
import org.sing_group.seda.plugin.spi.TransformationChangeEvent;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.util.FileUtils;
import org.sing_group.seda.util.SedaApplicationInfo;

public class SedaPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon ICON_LOGO = new ImageIcon(SedaPanel.class.getResource("image/logo.png"));
    private static final String INITIAL_PLUGIN_NAME = "Filtering";
    private final SedaGuiPlugin[] guiPlugins;
    private final Map<String, SedaGuiPlugin> guiPluginsMap = new HashMap<String, SedaGuiPlugin>();
    private JPanel cards;
    private JPanel pluginsPanel;
    private JButton btnProcessDataset;
    private JButton btnProcessClipboard;
    private List<String> cardsLabels;
    private Map<String, List<String>> operationGroups;
    private OutputConfigurationPanel panelOutputConfig;
    private SedaContext sedaContext = new SedaContext();
    private DatasetProcessor processor;
    private DatatypeFactory datatypeFactory;
    private SelectionPanel selectionPanel;
    private JTree operationsTree;
    private JTreeSelectionPanel operationsTreeSelectionPanel;
    private ExtendedAbstractAction saveCurrentOperationConfiguration;
    private ExtendedAbstractAction loadCurrentOperationConfiguration;
    public static final String WARNING_OUTPUT_DIR = "Warning: the selected output directory contains some of the selected files. This means the corresponding original files will be overwritten. Do you want to continue?";
    private JOptionPaneMessage outputDirWarningMessage = new JOptionPaneMessage("Warning: the selected output directory contains some of the selected files. This means the corresponding original files will be overwritten. Do you want to continue?");
    public static final String WARNING_OVERWRITE_CONFIG = "The selected configuration file already exists. Do you want to overwrite it?";
    private JOptionPaneMessage overwriteConfigWarningMessage = new JOptionPaneMessage("The selected configuration file already exists. Do you want to overwrite it?");
    private boolean warnReprocessFiles = false;
    public static final String WARNING_REPROCESS_FILES = "The file selection has not changed since the last operation executed. You may have forgotten to change it. Do you want to continue?";
    private JOptionPaneMessage reprocessFilesWarningMessage = new JOptionPaneMessage("The file selection has not changed since the last operation executed. You may have forgotten to change it. Do you want to continue?");

    public SedaPanel(SedaPluginManager pluginManager) {
        GuiUtils.configureUI();
        this.guiPlugins = (SedaGuiPlugin[])pluginManager.getFactories().flatMap(SedaPluginFactory::getGuiPlugins).sorted((p1, p2) -> {
            if (p1.getName().equals(INITIAL_PLUGIN_NAME)) {
                return -1;
            }
            return p2.getName().equals(INITIAL_PLUGIN_NAME) ? 1 : p1.getName().compareTo(p2.getName());
        }).toArray(SedaGuiPlugin[]::new);
        this.init();
        this.updateDatatypeFactory();
    }

    private void updateDatatypeFactory() {
        this.datatypeFactory = this.getDatatypeFactory();
        this.processor = new DatasetProcessor(this.datatypeFactory);
        this.selectionPanel.setDatasetFactory(this.datatypeFactory);
    }

    private DatatypeFactory getDatatypeFactory() {
        return DatatypeFactory.newFactory(this.getOutputConfigModel().isInMemoryProcessingEnabled(), this.selectionPanel.isCharsetSupportEnabled());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getSelectionPanel(), "North");
        this.add(this.getPluginsPanel(), "Center");
        this.add(this.getPanelOutput(), "South");
        this.updateProcessButtons();
        this.addListeners();
    }

    private Component getSelectionPanel() {
        this.selectionPanel = new SelectionPanel(this.datatypeFactory);
        this.selectionPanel.setBorder(SedaPanel.createSectionBorder("Input"));
        return this.selectionPanel;
    }

    private static final Border createSectionBorder(String title) {
        return BorderFactory.createTitledBorder(BorderFactory.createLoweredSoftBevelBorder(), title);
    }

    private Component getPluginsPanel() {
        this.cards = new JPanel(new CardLayout());
        this.cardsLabels = new LinkedList<String>();
        this.operationGroups = new HashMap<String, List<String>>();
        for (SedaGuiPlugin plugin : this.guiPlugins) {
            JPanel editorContainer = new JPanel(new BorderLayout());
            editorContainer.add(plugin.getEditor(), "North");
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setViewportView(editorContainer);
            scrollPane.getVerticalScrollBar().setUnitIncrement(15);
            scrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.operationGroups.putIfAbsent(plugin.getGroupName(), new LinkedList());
            this.operationGroups.get(plugin.getGroupName()).add(plugin.getName());
            this.cards.add((Component)scrollPane, plugin.getName());
            this.cardsLabels.add(plugin.getName());
            this.guiPluginsMap.put(plugin.getName(), plugin);
            plugin.getTransformation().addTransformationChangeListener(this::onTransformationChange);
            plugin.setSedaContext(this.sedaContext);
        }
        this.operationsTree = this.getOperationsTree();
        this.operationsTree.getSelectionModel().addTreeSelectionListener(this::selectedOperationChanged);
        this.operationsTreeSelectionPanel = new JTreeSelectionPanel(this.operationsTree, "Choose operation", true, false, true, false){
            private static final long serialVersionUID = 1L;

            @Override
            protected Dimension getSelectionLabelMinimumSize() {
                return new Dimension(350, 30);
            }

            @Override
            protected Font getSelectionLabelFont() {
                return new JLabel().getFont().deriveFont(1);
            }
        };
        this.operationsTreeSelectionPanel.setMaximumSize(new Dimension(100, 200));
        JPanel cardsNorthPanel = new JPanel();
        cardsNorthPanel.setLayout(new BoxLayout(cardsNorthPanel, 0));
        cardsNorthPanel.add(Box.createHorizontalGlue());
        cardsNorthPanel.add(this.operationsTreeSelectionPanel);
        cardsNorthPanel.add(Box.createHorizontalGlue());
        cardsNorthPanel.add(this.getOperationsMenu());
        this.pluginsPanel = new JPanel(new BorderLayout());
        this.pluginsPanel.add((Component)cardsNorthPanel, "North");
        this.cards.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        this.pluginsPanel.add((Component)this.cards, "Center");
        this.pluginsPanel.setBorder(SedaPanel.createSectionBorder("Process"));
        return this.pluginsPanel;
    }

    private JTree getOperationsTree() {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        };
        LinkedList<String> groups = new LinkedList<String>(this.operationGroups.keySet());
        Collections.sort(groups, comparator);
        TreePath initialPath = null;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        for (String groupName : groups) {
            DefaultMutableTreeNode currentNode = new DefaultMutableTreeNode(groupName);
            root.add(currentNode);
            List<String> operations = this.operationGroups.get(groupName);
            Collections.sort(operations, comparator);
            for (String o : operations) {
                DefaultMutableTreeNode operationNode = new DefaultMutableTreeNode(o);
                currentNode.add(operationNode);
                if (!o.equals(this.guiPlugins[0].getName())) continue;
                initialPath = new TreePath(operationNode.getPath());
            }
        }
        JTree tree = new JTree(root);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setSelectionModel(new PathCheckTreeSelectionModel());
        tree.getSelectionModel().setSelectionMode(1);
        JTreeUtils.collapseAll(tree);
        tree.getSelectionModel().setSelectionPath(initialPath);
        tree.updateUI();
        return tree;
    }

    private Component getOperationsMenu() {
        HamburgerMenu menu = new HamburgerMenu(HamburgerMenu.Size.SIZE16);
        this.saveCurrentOperationConfiguration = new ExtendedAbstractAction("Save current configuration", Icons.ICON_DOWNLOAD_2_16, this::saveCurrentOperationConfiguration);
        menu.add(this.saveCurrentOperationConfiguration);
        this.loadCurrentOperationConfiguration = new ExtendedAbstractAction("Load and update current configuration", Icons.ICON_UPLOAD_2_16, this::loadCurrentOperationConfiguration);
        menu.add(this.loadCurrentOperationConfiguration);
        return menu;
    }

    private void saveCurrentOperationConfiguration() {
        SedaGuiPlugin activePlugin = this.getActivePlugin();
        if (activePlugin.canSaveTransformation()) {
            JFileChooser fileChooser = CommonFileChooser.getInstance().getFilechooser();
            GuiUtils.showFileChooserAndProcess(fileChooser, this, 0, 1, false, Collections.emptyList(), file -> this.saveTransformation(activePlugin, file.toFile()));
        }
    }

    private void saveTransformation(SedaGuiPlugin plugin, File file) {
        if (file.exists() && this.overwriteConfigWarningMessage.shouldBeShown() && SedaPanel.showWarning(this, this.overwriteConfigWarningMessage) == 1) {
            return;
        }
        try {
            plugin.saveTransformation(file);
        }
        catch (IOException e) {
            this.handleException(e, "An error ocurred while saving the configuration.");
        }
    }

    private static int showWarning(Component parent, JOptionPaneMessage warningMessage) {
        return JOptionPane.showConfirmDialog(parent, warningMessage.getMessage(), "Warning", 0, 2);
    }

    private void loadCurrentOperationConfiguration() {
        SedaGuiPlugin activePlugin = this.getActivePlugin();
        JFileChooser fileChooser = CommonFileChooser.getInstance().getFilechooser();
        if (activePlugin.canSaveTransformation()) {
            GuiUtils.showFileChooserAndProcess(fileChooser, this, 0, 0, false, Collections.emptyList(), file -> this.loadTransformation(activePlugin, file.toFile()));
        }
    }

    private void loadTransformation(SedaGuiPlugin plugin, File file) {
        try {
            plugin.loadTransformation(file);
            plugin.getTransformation().addTransformationChangeListener(this::onTransformationChange);
            this.onTransformationChange();
        }
        catch (IOException e) {
            this.handleException(e, "An error ocurred while loading the configuration.\n\nPlease, make sure that the corresponding configuration file is valid and correspond to the active operation.");
        }
    }

    private void handleException(IOException e, String message) {
        e.printStackTrace();
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    private Component getPanelOutput() {
        this.panelOutputConfig = new OutputConfigurationPanel();
        this.getOutputConfigModel().addOutputConfigurationModelListener(this::outputConfigurationModelChanged);
        JPanel panelOutputConfigContainer = new JPanel();
        panelOutputConfigContainer.add(this.panelOutputConfig);
        JPanel panelOutput = new JPanel(new BorderLayout());
        panelOutput.add((Component)panelOutputConfigContainer, "Center");
        this.btnProcessDataset = new JButton("Process selected files");
        this.btnProcessDataset.addActionListener(event -> this.processSelectedFiles());
        this.btnProcessClipboard = new JButton("Process clipboard content");
        this.btnProcessClipboard.addActionListener(event -> this.processClipboard());
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(this.btnProcessDataset);
        buttonsPanel.add(Box.createHorizontalStrut(10));
        buttonsPanel.add(this.btnProcessClipboard);
        panelOutput.add((Component)new CenteredJPanel(buttonsPanel), "South");
        panelOutput.setBorder(SedaPanel.createSectionBorder("Output"));
        return panelOutput;
    }

    private void outputConfigurationModelChanged(OutputConfigurationModelEvent event) {
        if (event.getType().equals((Object)OutputConfigurationModelEvent.OutputConfigurationModelEventType.IN_MEMORY_PROCESSING_ENABLED)) {
            this.updateDatatypeFactory();
            this.updateSedaContextProcessingMode();
        }
        if (event.getType().equals((Object)OutputConfigurationModelEvent.OutputConfigurationModelEventType.OUTPUT_DIRECTORY_CHANGED)) {
            this.checkOutputDirectory();
        }
    }

    private void updateSedaContextProcessingMode() {
        this.sedaContext.setInMemoryProcessingEnabled(this.getOutputConfigModel().isInMemoryProcessingEnabled());
    }

    private void selectedOperationChanged(TreeSelectionEvent e) {
        CardLayout cl = (CardLayout)this.cards.getLayout();
        cl.show(this.cards, this.getSelectedOperationName());
        this.onTransformationChange();
    }

    private String getSelectedOperationName() {
        return ((DefaultMutableTreeNode)this.operationsTree.getSelectionModel().getSelectionPath().getLastPathComponent()).toString();
    }

    private void updateTransformationActionsState() {
        SedaGuiPlugin activePlugin = this.getActivePlugin();
        this.saveCurrentOperationConfiguration.setEnabled(activePlugin.canSaveTransformation() && activePlugin.getTransformation().validate().isValid());
        this.loadCurrentOperationConfiguration.setEnabled(activePlugin.canSaveTransformation());
    }

    private void updateTransformationDescriptionTooltip() {
        SedaGuiPlugin activePlugin = this.getActivePlugin();
        this.operationsTreeSelectionPanel.getSelectionLabel().setToolTipText(activePlugin.getDescription());
    }

    private void onTransformationChange(TransformationChangeEvent event) {
        this.onTransformationChange();
    }

    private void onTransformationChange() {
        SwingUtilities.invokeLater(() -> {
            this.getActivePlugin().getEditor().setCursor(Cursor.getPredefinedCursor(3));
            this.updateProcessButtons();
            this.updateTransformationActionsState();
            this.updateTransformationDescriptionTooltip();
            this.getActivePlugin().getEditor().setCursor(Cursor.getDefaultCursor());
        });
    }

    private void updateSedaContextSelectedPaths() {
        this.sedaContext.setSelectedPaths(this.getPathSelectionModel().getSelectedPaths().collect(Collectors.toList()));
    }

    private void updateReprocessStatus(boolean warnReprocessFiles) {
        this.warnReprocessFiles = warnReprocessFiles;
    }

    private void updateProcessButtons() {
        SedaGuiPlugin activePlugin = this.getActivePlugin();
        Validation activePluginValidation = activePlugin.getTransformation().validate();
        boolean activePluginConfigurationValid = activePluginValidation.isValid();
        this.btnProcessClipboard.setEnabled(activePluginConfigurationValid);
        this.btnProcessDataset.setEnabled(this.getPathSelectionModel().countSelectedPaths() > 0 && activePluginConfigurationValid);
        String tooltip = this.getActivePluginConfigurationTooltip(activePluginValidation, activePlugin.getProcessDatasetButtonTooltipMessage());
        this.btnProcessClipboard.setToolTipText(tooltip.isEmpty() ? null : tooltip);
        this.btnProcessDataset.setToolTipText(tooltip.isEmpty() ? null : tooltip);
    }

    private void checkOutputDirectory() {
        this.panelOutputConfig.showOutputDirectoryWarning(this.outputDirectoryOverwriteInput());
    }

    private boolean outputDirectoryOverwriteInput() {
        Set inputDirectories = this.getPathSelectionModel().getSelectedPaths().map(p -> new File((String)p).getParent()).collect(Collectors.toSet());
        return inputDirectories.contains(this.getOutputConfigModel().getOutputDirectoryPath());
    }

    private String getActivePluginConfigurationTooltip(Validation activePluginValidation, Optional<String> tooltipMessage) {
        ArrayList<String> messages = new ArrayList<String>(activePluginValidation.getValidationErrors());
        if (tooltipMessage.isPresent()) {
            messages.add(tooltipMessage.get());
        }
        if (messages.isEmpty()) {
            return "";
        }
        return messages.stream().collect(Collectors.joining("</li><li>", "<html><li>", "</li></html>"));
    }

    private SedaGuiPlugin getActivePlugin() {
        return this.guiPluginsMap.get(this.getSelectedOperationName());
    }

    private void addListeners() {
        this.getPathSelectionModel().addPathSelectionModelListener(event -> {
            if (event.getType().isSelectedEvent()) {
                this.updateProcessButtons();
                this.updateSedaContextSelectedPaths();
                this.checkOutputDirectory();
                this.updateReprocessStatus(false);
            }
        });
        this.selectionPanel.addPropertyChangeListener("property.charset.support", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SedaPanel.this.charsetSupportChanged();
            }
        });
    }

    private void charsetSupportChanged() {
        this.sedaContext.setCharsetSupport(this.selectionPanel.isCharsetSupportEnabled());
        this.updateDatatypeFactory();
    }

    private SequencesGroupDatasetTransformation getTransformation() {
        SedaGuiPlugin activePlugin = this.getActivePlugin();
        return activePlugin.getTransformation().getTransformation(this.datatypeFactory);
    }

    private void processClipboard() {
        Optional<Path> temporaryClipboardFile = FileUtils.getTemporaryClipboardFile();
        if (temporaryClipboardFile.isPresent()) {
            try {
                this.datatypeFactory.newSequencesGroup(temporaryClipboardFile.get());
                int option = JOptionPane.showConfirmDialog(this, this.getDatasetPreview(temporaryClipboardFile.get()), "Process clipboard", 0, 3);
                if (option == 0) {
                    this.processPaths(Arrays.asList(temporaryClipboardFile.get()).stream());
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "The clipboard content cannot be processed as a FASTA file.", "Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "The clipboard is empty.", "Warning", 2);
        }
    }

    private JComponent getDatasetPreview(Path path) {
        String lines = "";
        try {
            lines = Files.readAllLines(path).stream().collect(Collectors.joining("\n"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JTextArea textArea = new JTextArea(lines);
        textArea.setColumns(100);
        textArea.setRows(20);
        return new JScrollPane(textArea);
    }

    private void processPaths(Stream<Path> paths) {
        WorkingDialog dialog = new WorkingDialog((Frame)((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this)), "Executing task", "Running " + this.getActivePlugin().getName());
        new CustomSwingWorker(() -> {
            OutputConfigurationModel outputModel = this.getOutputConfigModel();
            Path output = outputModel.getOutputDirectory();
            int groupSize = outputModel.isSplitInSubdirectories() ? outputModel.getSubdirectorySize() : 0;
            DatasetProcessorConfiguration configuration = new DatasetProcessorConfiguration(groupSize, outputModel.isWriteGzip());
            SequencesGroupDatasetTransformation transformation = this.getTransformation();
            long start = System.nanoTime();
            try {
                this.processor.process(paths, output, transformation, configuration);
                long end = System.nanoTime();
                dialog.dispose();
                long interval = end - start;
                StringBuilder message = new StringBuilder("Transformation completed without any error.");
                message.append("\n\nYou can find the resulting dataset in: ").append(output.toString()).append(".\n\nThe operation took ").append(this.nanosToHms(interval)).append(" to complete.");
                JOptionPane.showMessageDialog(this, message.toString(), "Transformation Completed", 1);
            }
            catch (Throwable e) {
                long end = System.nanoTime();
                e.printStackTrace();
                dialog.dispose();
                long interval = end - start;
                StringBuilder message = new StringBuilder("Error transforming dataset: ");
                message.append(e.getMessage()).append(".<br/><br/>The operation ran ").append(this.nanosToHms(interval)).append(" before failing.");
                if (e instanceof OutOfMemoryError) {
                    message.append("<br/><br/>Please, visit the SEDA manual to know how to fix this issue: ").append("<a href=\"https://www.sing-group.org/seda/manual/installation-and-configuration.html#increasing-ram-memory\">").append("Installation and configuration / Increasing RAM memory</a>");
                }
                JOptionPane.showMessageDialog(this, new HtmlMessage(message.toString()), "Transformation Error", 0);
            }
        }).execute();
        dialog.setVisible(true);
    }

    private String nanosToHms(long nanos) {
        return String.format("%02d:%02d:%02d", TimeUnit.NANOSECONDS.toHours(nanos), TimeUnit.NANOSECONDS.toMinutes(nanos) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.NANOSECONDS.toSeconds(nanos) % TimeUnit.MINUTES.toSeconds(1L));
    }

    private void processSelectedFiles() {
        if (this.warnReprocessFiles && this.reprocessFilesWarningMessage.shouldBeShown() && SedaPanel.showWarning(this, this.reprocessFilesWarningMessage) == 1) {
            return;
        }
        if (this.outputDirectoryOverwriteInput() && this.outputDirWarningMessage.shouldBeShown() && SedaPanel.showWarning(this, this.outputDirWarningMessage) == 1) {
            return;
        }
        PathSelectionModel pathsModel = this.getPathSelectionModel();
        Stream<Path> paths = pathsModel.getSelectedPaths().map(x$0 -> Paths.get(x$0, new String[0]));
        this.processPaths(paths);
        this.updateReprocessStatus(true);
    }

    private OutputConfigurationModel getOutputConfigModel() {
        return this.panelOutputConfig.getModel();
    }

    private PathSelectionModel getPathSelectionModel() {
        return this.selectionPanel.getModel();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            Locale.setDefault(Locale.ENGLISH);
            JFrame frame = new JFrame(SedaApplicationInfo.getName());
            SedaPluginManager pluginManager = new SedaPluginManager();
            frame.setContentPane(new SedaPanel(pluginManager));
            frame.setIconImage(ICON_LOGO.getImage());
            frame.setExtendedState(6);
            frame.setDefaultCloseOperation(3);
            frame.setLocationRelativeTo(null);
            frame.setMinimumSize(new Dimension(200, 200));
            frame.setVisible(true);
        });
    }
}

