/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.split;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterator;
import org.sing_group.seda.core.split.AbstractSequencesGroupSplitter;
import org.sing_group.seda.core.split.DefaultSequencesSort;
import org.sing_group.seda.core.split.SequencesSort;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;

public class NumberOfSequencesSplitter
extends AbstractSequencesGroupSplitter {
    private int numSequences;

    public NumberOfSequencesSplitter(int numSequences) {
        this(numSequences, new DefaultSequencesSort(), DatatypeFactory.getDefaultDatatypeFactory());
    }

    public NumberOfSequencesSplitter(int numSequences, SequencesSort sequencesSort, DatatypeFactory factory) {
        super(sequencesSort, factory);
        this.numSequences = numSequences;
    }

    @Override
    public List<SequencesGroup> split(SequencesGroup group) {
        List<Sequence> input = this.getInputSequencesGroup(group);
        Spliterator<Sequence> splitIterator = input.spliterator();
        int splitCount = 1;
        LinkedList<SequencesGroup> toret = new LinkedList<SequencesGroup>();
        while (true) {
            ArrayList<Sequence> chunk = new ArrayList<Sequence>(this.numSequences);
            for (int i = 0; i < this.numSequences; ++i) {
                if (!splitIterator.tryAdvance(chunk::add)) break;
            }
            if (chunk.isEmpty()) break;
            toret.add(this.createGroup(group.getName() + "_" + splitCount++, group.getProperties(), chunk));
        }
        return toret;
    }
}

