/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.split;

import java.util.LinkedList;
import java.util.List;
import org.sing_group.seda.core.split.AbstractSequencesGroupSplitter;
import org.sing_group.seda.core.split.DefaultSequencesSort;
import org.sing_group.seda.core.split.SequencesSort;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.transformation.TransformationException;

public class NumberOfSequencesAndNumberOfFilesSplitter
extends AbstractSequencesGroupSplitter {
    private int numFiles;
    private int numSequences;

    public NumberOfSequencesAndNumberOfFilesSplitter(int numFiles, int numSequences) {
        this(numFiles, numSequences, new DefaultSequencesSort(), DatatypeFactory.getDefaultDatatypeFactory());
    }

    public NumberOfSequencesAndNumberOfFilesSplitter(int numFiles, int numSequences, SequencesSort sequencesSort, DatatypeFactory factory) {
        super(sequencesSort, factory);
        this.numFiles = numFiles;
        this.numSequences = numSequences;
    }

    @Override
    public List<SequencesGroup> split(SequencesGroup group) {
        if (this.numFiles * this.numSequences > group.getSequenceCount()) {
            throw new TransformationException("Not enough sequences. The result of multiplying the number of files by the number of sequences must be less than or equal to the actual number of sequences.");
        }
        LinkedList<SequencesGroup> toret = new LinkedList<SequencesGroup>();
        List<Sequence> input = this.getInputSequencesGroup(group);
        for (int file = 0; file < this.numFiles; ++file) {
            int startIndex = file * this.numSequences;
            int endIndex = (file + 1) * this.numSequences;
            List<Sequence> currentSubList = input.subList(startIndex, endIndex);
            toret.add(this.createGroup(group.getName() + "_" + (file + 1), group.getProperties(), currentSubList));
        }
        return toret;
    }
}

