/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.ncbi;

import java.net.URISyntaxException;
import java.net.URL;

public class NcbiAssemblyAccession {
    private String accession;
    private String organismName;
    private URL taxonomyUrl;

    public NcbiAssemblyAccession(String accession, String organismName, URL taxonomyUrl) {
        this.accession = accession;
        this.organismName = organismName;
        this.taxonomyUrl = taxonomyUrl;
    }

    public String getAccession() {
        return this.accession;
    }

    public String getOrganismName() {
        return this.organismName;
    }

    public URL getTaxonomyUrl() {
        return this.taxonomyUrl;
    }

    public String toString() {
        return this.accession + " [Organism name = " + this.organismName + "] [" + this.taxonomyUrl + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accession == null ? 0 : this.accession.hashCode());
        result = 31 * result + (this.organismName == null ? 0 : this.organismName.hashCode());
        try {
            result = 31 * result + (this.taxonomyUrl == null ? 0 : this.taxonomyUrl.toURI().hashCode());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NcbiAssemblyAccession other = (NcbiAssemblyAccession)obj;
        if (this.accession == null ? other.accession != null : !this.accession.equals(other.accession)) {
            return false;
        }
        if (this.organismName == null ? other.organismName != null : !this.organismName.equals(other.organismName)) {
            return false;
        }
        if (this.taxonomyUrl == null) {
            if (other.taxonomyUrl != null) {
                return false;
            }
        } else {
            try {
                if (!this.taxonomyUrl.toURI().equals(other.taxonomyUrl.toURI())) {
                    return false;
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

