/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.parameters;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.util.Arrays;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.core.filtering.RegexConfiguration;
import org.sing_group.seda.core.filtering.RegexHeaderMatcher;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.plugin.core.info.common.RegexHeaderMatcherInfo;

public class RegexHeaderMatcherCliParameters {
    public static final DefaultValuedStringOption OPTION_STRING = new DefaultValuedStringOption("string-match", "rs", "The regular expression that must be matched in the sequence header.", ".*");
    public static final FlagOption OPTION_QUOTE_PATTERN = new FlagOption("quote-pattern", "rqp", "Whether the regular expression pattern must be quoted or not. When the regular expression is quoted, metacharacters or escape sequences in it will be given no special meaning.");
    public static final IntegerDefaultValuedStringConstructedOption OPTION_GROUP = new IntegerDefaultValuedStringConstructedOption("regex-group", "rg", "The regular expression group that must be extracted. Default value is 0, meaning that the entire result must be considered. Use values higher than 0 when there are brackets in the regular expression in order to select the desired group.", 0);
    public static final FlagOption OPTION_CASE_SENSITIVE = new FlagOption("case-sensitive", "rcs", "Whether the string must be matched as case sensitive or not.");
    public static final DefaultValuedStringOption OPTION_HEADER_TARGET = new DefaultValuedStringOption("header-target", "rht", RegexHeaderMatcherInfo.PARAM_REGEX_HEADER_TARGET_HELP, HeaderTarget.NAME.name().toLowerCase());

    public static List<Option<?>> getOptionList() {
        return Arrays.asList(OPTION_STRING, OPTION_QUOTE_PATTERN, OPTION_GROUP, OPTION_CASE_SENSITIVE, OPTION_HEADER_TARGET);
    }

    public static RegexHeaderMatcher getRegexHeaderMatcher(Parameters parameters) {
        SedaCommand.checkMandatoryOption(parameters, OPTION_STRING);
        String regex = parameters.getSingleValueString(OPTION_STRING);
        if (regex.isEmpty()) {
            SedaCommand.invalidOptionValue(OPTION_STRING, "String option cant be empty");
        }
        HeaderTarget headerTarget = null;
        try {
            headerTarget = HeaderTarget.valueOf(parameters.getSingleValueString(OPTION_HEADER_TARGET).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SedaCommand.invalidEnumValue(OPTION_HEADER_TARGET);
        }
        RegexConfiguration regexConfiguration = new RegexConfiguration(parameters.hasFlag(OPTION_CASE_SENSITIVE), parameters.getSingleValue(OPTION_GROUP), parameters.hasFlag(OPTION_QUOTE_PATTERN));
        try {
            return new RegexHeaderMatcher(regex, headerTarget, regexConfiguration);
        }
        catch (PatternSyntaxException e) {
            SedaCommand.formattedValidationError("The regular expression specified by " + regex + " is not valid.");
            throw new IllegalStateException();
        }
    }
}

