/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.util.ArrayList;
import java.util.List;
import org.sing_group.seda.cli.command.RenameHeaderCommand;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.core.rename.IntervalReplaceRenamer;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.rename.RenameHeaderTransformationProvider;

public class RenameHeaderReplaceIntervalCommand
extends RenameHeaderCommand {
    public static final StringOption OPTION_FROM = new StringOption("from", "fr", "The starting string of the interval.", true, true);
    public static final StringOption OPTION_TO_DELIMITER = new StringOption("to", "to", "The ending string of the interval.", true, true);
    public static final DefaultValuedStringOption OPTION_REPLACEMENT = new DefaultValuedStringOption("interval-replacement", "ir", "The interval replacement.", "");

    @Override
    public String getName() {
        return "rename-header-replace-interval";
    }

    @Override
    public String getDescriptiveName() {
        return "Rename header (Replace interval)";
    }

    @Override
    public String getDescription() {
        return "Modify sequence headers by replacing information (target interval).";
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        ArrayList options = new ArrayList();
        options.addAll(super.createSedaOptions());
        options.add(OPTION_FROM);
        options.add(OPTION_TO_DELIMITER);
        options.add(OPTION_REPLACEMENT);
        return options;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        RenameHeaderTransformationProvider provider = new RenameHeaderTransformationProvider();
        RenameHeaderReplaceIntervalCommand.checkMandatoryOption(parameters, OPTION_FROM);
        RenameHeaderReplaceIntervalCommand.checkMandatoryOption(parameters, OPTION_TO_DELIMITER);
        String from = parameters.getSingleValue(OPTION_FROM);
        String to = parameters.getSingleValue(OPTION_TO_DELIMITER);
        String replacement = parameters.getSingleValue(OPTION_REPLACEMENT);
        HeaderTarget headerTarget = this.getHeaderTarget(parameters);
        provider.setHeaderRenamer(new IntervalReplaceRenamer(headerTarget, from, to, replacement));
        return provider;
    }
}

