/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FileOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.cli.parameters.RegexHeaderMatcherCliParameters;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.operations.DefaultSequenceIsoformSelector;
import org.sing_group.seda.core.rename.EmptySequenceHeadersJoiner;
import org.sing_group.seda.core.rename.HeaderTarget;
import org.sing_group.seda.core.rename.SequenceHeadersJoiner;
import org.sing_group.seda.plugin.core.info.plugin.RemoveIsoformsSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.isoforms.RemoveIsoformsTransformationProvider;

public class RemoveIsoformsCommand
extends SedaCommand {
    public static final IntegerDefaultValuedStringConstructedOption OPTION_MINIMUM_WORD_LENGH = new IntegerDefaultValuedStringConstructedOption("minimum-word-length", "mwl", "The minimum length of word to consider that two sequences are isoforms.", 250);
    public static final IntegerDefaultValuedStringConstructedOption OPTION_REFERENCE_SIZE = new IntegerDefaultValuedStringConstructedOption("reference-size", "rs", "The isoform with the length closest to this reference size will be selected. In case of having two isoforms that are at the same distance, the tie break mode option allows specifying which one should be selected.", 250);
    public static final DefaultValuedStringOption OPTION_TIE_BREAK = new DefaultValuedStringOption("tie-break-mode", "tbm", RemoveIsoformsSedaPluginInfo.PARAM_TIE_BREAK_HELP, RemoveIsoformsSedaPluginInfo.DEFAULT_REMOVE_ISOFORM_TIE_BREAK_OPTION.name().toLowerCase());
    public static final FlagOption OPTION_GROUP_SEQUENCES_REGEX = new FlagOption("group-sequences-regex", "gsr", "This option allows to specify whether sequences must be grouped before the identification of the isoforms. Don't use this flag if isoforms must be removed at a file level. In contrast, if you want to make groups of sequences before the identification of the isoforms, this flag allows regex options to configure how sequence headers must be matched in order to group sequences. Check the manual for examples.");
    public static final FlagOption OPTION_REMOVE_ISOFORM_HEADER = new FlagOption("add-removed-isoform-headers", "arih", "Whether the removed isoform headers should be added to the header of the selected isoform.");
    public static final DefaultValuedStringOption OPTION_HEADER_TARGET = new DefaultValuedStringOption("header-target", "ht", RemoveIsoformsSedaPluginInfo.PARAM_HEADER_TARGET_HELP, RemoveIsoformsSedaPluginInfo.DEFAULT_REMOVE_ISOFORM_HEADER_TARGET.name().toLowerCase());
    public static final FileOption OPTION_FILE_NAME = new FileOption("isoform-files-directory", "ifd", "Whether the removed isoform names should be saved into a CSV file or not. This allows an easy identification of those sequences that had isoforms in the output files. If you do not want to save them, leave this file empty. Otherwise, choose the directory where such files should be created.", true, true);

    @Override
    public String getName() {
        return "remove-isoforms";
    }

    @Override
    public String getDescriptiveName() {
        return "Remove isoforms";
    }

    @Override
    public String getDescription() {
        return "Keep the isoform with the size closest to that specified, and remove all other isoforms, identified based on a shared word of specified length.";
    }

    @Override
    protected String getSedaGroup() {
        return RemoveIsoformsSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        ArrayList optionList = new ArrayList();
        optionList.add(OPTION_MINIMUM_WORD_LENGH);
        optionList.add(OPTION_REFERENCE_SIZE);
        optionList.add(OPTION_TIE_BREAK);
        optionList.add(OPTION_REMOVE_ISOFORM_HEADER);
        optionList.add(OPTION_HEADER_TARGET);
        optionList.add(OPTION_FILE_NAME);
        optionList.add(OPTION_GROUP_SEQUENCES_REGEX);
        optionList.addAll(RegexHeaderMatcherCliParameters.getOptionList());
        return optionList;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        RemoveIsoformsTransformationProvider provider = new RemoveIsoformsTransformationProvider();
        provider.setMinimumWordLength(parameters.getSingleValue(OPTION_MINIMUM_WORD_LENGH));
        provider.setIsoformSelector(this.getIsoformSelector(parameters));
        if (parameters.hasFlag(OPTION_GROUP_SEQUENCES_REGEX)) {
            try {
                provider.setHeaderMatcher(RegexHeaderMatcherCliParameters.getRegexHeaderMatcher(parameters));
            }
            catch (IllegalArgumentException e) {
                RemoveIsoformsCommand.formattedValidationError(e.getMessage());
            }
        }
        provider.setSequenceHeaderJoiner(this.getSequenceHeadersJoiner(parameters));
        if (parameters.hasOption(OPTION_FILE_NAME)) {
            File isoformsFilesDirectory = parameters.getSingleValue(OPTION_FILE_NAME);
            if (!isoformsFilesDirectory.isDirectory()) {
                RemoveIsoformsCommand.formattedValidationError(RemoveIsoformsCommand.formatParam(OPTION_FILE_NAME) + " must be a directory");
            }
            provider.setRemovedIsoformFilesDirectory(isoformsFilesDirectory);
        }
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, RemoveIsoformsTransformationProvider.class);
    }

    private DefaultSequenceIsoformSelector getIsoformSelector(Parameters parameters) {
        DefaultSequenceIsoformSelector.TieBreakOption tieBreak = null;
        try {
            tieBreak = DefaultSequenceIsoformSelector.TieBreakOption.valueOf(parameters.getSingleValue(OPTION_TIE_BREAK).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            RemoveIsoformsCommand.invalidEnumValue(OPTION_TIE_BREAK);
        }
        return new DefaultSequenceIsoformSelector(parameters.getSingleValue(OPTION_REFERENCE_SIZE), tieBreak);
    }

    public SequenceHeadersJoiner getSequenceHeadersJoiner(Parameters parameters) {
        if (parameters.hasFlag(OPTION_REMOVE_ISOFORM_HEADER)) {
            HeaderTarget headerTarget = null;
            try {
                headerTarget = HeaderTarget.valueOf(parameters.getSingleValue(OPTION_HEADER_TARGET).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                RemoveIsoformsCommand.invalidEnumValue(OPTION_HEADER_TARGET);
            }
            return new SequenceHeadersJoiner(headerTarget, ", ", "[", "]");
        }
        return new EmptySequenceHeadersJoiner();
    }
}

