/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sing_group.seda.cli.command.ReformatFastaCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.core.info.plugin.MergeSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.merge.MergeTransformationProvider;
import org.sing_group.seda.transformation.provider.reformat.ReformatFastaTransformationProvider;

public class MergeCommand
extends ReformatFastaCommand {
    public static final StringOption OPTION_NAME = new StringOption("name", "n", "The name of the merged file.", true, true);

    @Override
    public String getName() {
        return "merge";
    }

    @Override
    public String getDescriptiveName() {
        return "Merge";
    }

    @Override
    public String getDescription() {
        return "Merge all input FASTA files into a single output FASTA.";
    }

    @Override
    protected String getSedaGroup() {
        return MergeSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        ArrayList options = new ArrayList();
        options.add(OPTION_NAME);
        options.addAll(super.createSedaOptions());
        return options;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        MergeTransformationProvider provider = new MergeTransformationProvider();
        provider.setName(parameters.getSingleValue(OPTION_NAME));
        provider.setReformatFastaTransformationProvider((ReformatFastaTransformationProvider)super.getTransformation(parameters));
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, MergeTransformationProvider.class);
    }

    @Override
    protected List<Option<?>> getMandatoryOptions() {
        return Arrays.asList(OPTION_NAME);
    }
}

