/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.operations.BasePresence;
import org.sing_group.seda.plugin.core.info.plugin.FilterByBasePresenceSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.filtering.base.FilterByBasePresenceTransformationProvider;

public class FilterByBasePresenceCommand
extends SedaCommand {
    public static final StringOption OPTION_BASE_FILTERING = new StringOption("base-filter", "bf", "The base(s) whose percentage must be between the specified limits. If multiple bases are specified, the sum of each single base percentage is used.\nBy default, each base(s) filter uses a minimum of 0 and a maximum of 1. These limits can be specified adding 'config(min_presence/max_presence)' before the base(s), where:\n\t- min_presence (<Number with decimals between 0 and 1>): Minimum % required for the base(s).\n\t- max_presence (<Number with decimals between 0 and 1>): Maximum % allowed for the base(s).\nExample: --base-filtering config(0.35/0.4):TG\n", true, true, true);

    @Override
    public String getName() {
        return "base-filtering";
    }

    @Override
    public String getDescriptiveName() {
        return "Base presence filtering";
    }

    @Override
    public String getDescription() {
        return "Filter sequences based on the percentages of their bases (nucleotides or amino acids).";
    }

    @Override
    protected String getSedaGroup() {
        return FilterByBasePresenceSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        return Arrays.asList(OPTION_BASE_FILTERING);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        FilterByBasePresenceTransformationProvider provider = new FilterByBasePresenceTransformationProvider();
        try {
            provider.setBasePresences(parameters.getAllValues(OPTION_BASE_FILTERING).stream().map(BasePresenceString::new).collect(Collectors.toList()));
        }
        catch (IllegalArgumentException e) {
            FilterByBasePresenceCommand.formattedValidationError("Wrong " + FilterByBasePresenceCommand.formatParam(OPTION_BASE_FILTERING) + " configuration. Type 'help <command>' to see the available options.");
        }
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, FilterByBasePresenceTransformationProvider.class);
    }

    @Override
    protected List<Option<?>> getMandatoryOptions() {
        return Arrays.asList(OPTION_BASE_FILTERING);
    }

    public static class BasePresenceString
    extends BasePresence {
        private static final double MIN_PRESENCE = 0.0;
        private static final double MAX_PRESENCE = 1.0;
        private static final String CONFIG_BASE_FILTER_REGEX = "config\\((1|0(.[0-9]+)?)/(1|0(.[0-9]+)?)\\):[a-zA-Z]+";

        public BasePresenceString(String basePresence) {
            double minimumPresence = 0.0;
            double maximumPresence = 1.0;
            String base = basePresence;
            if (basePresence.contains("config")) {
                if (!basePresence.matches(CONFIG_BASE_FILTER_REGEX)) {
                    throw new IllegalArgumentException("Wrong configuration. Type 'help <command>' to see the available options.");
                }
                String config = basePresence.split(":")[0].replace("config", "").replace("(", "").replace(")", "");
                minimumPresence = Double.parseDouble(config.split("/")[0]);
                maximumPresence = Double.parseDouble(config.split("/")[1]);
                base = basePresence.split(":")[1];
            }
            this.minimumPresence = minimumPresence;
            this.maximumPresence = maximumPresence;
            this.bases = BasePresenceString.requireNonEmptyList(BasePresenceString.getBasesList(base.toCharArray()));
        }
    }
}

