/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli;

import es.uvigo.ei.sing.yacli.command.AbstractCommand;
import es.uvigo.ei.sing.yacli.command.option.BooleanOption;
import es.uvigo.ei.sing.yacli.command.option.FileOption;
import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.OptionCategory;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.InDiskDatatypeFactory;
import org.sing_group.seda.io.DatasetProcessor;
import org.sing_group.seda.io.DatasetProcessorConfiguration;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.TransformationException;

public abstract class SedaCommand
extends AbstractCommand {
    protected static final String OPTION_INPUT_DIRECTORY_NAME = "input-directory";
    protected static final String OPTION_OUTPUT_DIRECTORY_NAME = "output-directory";
    protected static final String OPTION_INPUT_FILE_NAME = "input-file";
    protected static final String OPTION_INPUT_LIST_NAME = "input-list";
    protected static final String OPTION_PARAMETERS_FILE_NAME = "parameters-file";
    protected static final String OPTION_SAVE_PARAMETERS_FILE_NAME = "save-parameters-file";
    protected static final String OPTION_OUTPUT_GROUP_SIZE_NAME = "output-group-size";
    protected static final String OPTION_OUTPUT_GZIP_NAME = "output-gzip";
    protected static final String OPTION_DISK_PROCESSING_NAME = "in-disk-processing";
    public static final List<OptionCategory> GROUP_INPUT = Arrays.asList(new OptionCategory("Input options"));
    public static final FileOption OPTION_INPUT_DIRECTORY = new FileOption(GROUP_INPUT, "input-directory", "id", "Path to the folder containing the files to process.", true, true);
    public static final FileOption OPTION_INPUT_FILE = new FileOption(GROUP_INPUT, "input-file", "if", "Path to the file to process.", true, true, true);
    public static final FileOption OPTION_INPUT_LIST = new FileOption(GROUP_INPUT, "input-list", "il", "Plain-text file with the paths of the files to process.", true, true);
    public static final List<OptionCategory> GROUP_OUTPUT = Arrays.asList(new OptionCategory("Output options"));
    public static final FileOption OPTION_OUTPUT_DIRECTORY = new FileOption(GROUP_OUTPUT, "output-directory", "od", "Path to the folder to create the result files.", false, true);
    public static final BooleanOption OPTION_OUTPUT_GZIP = new BooleanOption(GROUP_OUTPUT, "output-gzip", "gz", "Whether the output files must be compressed using gzip.", true, false);
    public static final IntegerDefaultValuedStringConstructedOption OPTION_OUTPUT_GROUP_SIZE = new IntegerDefaultValuedStringConstructedOption(GROUP_OUTPUT, "output-group-size", "sz", "Whether output files must be split into subdirectories of a defined size. By default (0), no split subdirectories are created.", 0);
    public static final List<OptionCategory> GROUP_CONFIGURATION = Arrays.asList(new OptionCategory("Configuration options"));
    public static final FlagOption OPTION_DISK_PROCESSING = new FlagOption(GROUP_CONFIGURATION, "in-disk-processing", "dp", "Whether files must be procesed in hard disk. If not specified, files are processed in RAM memory. This option is slower but allows processing big batches of files with thousands of sequences.");
    public static final List<OptionCategory> GROUP_COMMAND_OPTIONS = Arrays.asList(new OptionCategory("Command configuration files"));
    public static final FileOption OPTION_PARAMETERS_FILE = new FileOption(GROUP_COMMAND_OPTIONS, "parameters-file", "pf", "File with the command configuration (created using --save-parameters-file/-spf or the GUI) to load the command options.", true, true);
    public static final FileOption OPTION_SAVE_PARAMETERS_FILE = new FileOption(GROUP_COMMAND_OPTIONS, "save-parameters-file", "spf", "File to save the command configuration options for later reuse.", true, true);

    @Override
    protected List<Option<?>> createOptions() {
        ArrayList options = new ArrayList();
        options.add(OPTION_INPUT_DIRECTORY);
        options.add(OPTION_OUTPUT_DIRECTORY);
        options.add(OPTION_INPUT_FILE);
        options.add(OPTION_INPUT_LIST);
        options.add(OPTION_PARAMETERS_FILE);
        options.add(OPTION_SAVE_PARAMETERS_FILE);
        options.add(OPTION_OUTPUT_GROUP_SIZE);
        options.add(OPTION_OUTPUT_GZIP);
        options.add(OPTION_DISK_PROCESSING);
        options.addAll(this.createSedaOptions());
        return options;
    }

    @Override
    public void execute(Parameters parameters) throws Exception {
        this.checkInputOptions(parameters);
        Stream<Path> inputs = this.getInputPaths(parameters);
        Path output = this.getOutputPath(parameters);
        DatasetProcessorConfiguration configuration = this.getConfiguration(parameters);
        DatatypeFactory datatypeFactory = this.getDatatypeFactory(parameters);
        TransformationProvider transformation = this.getTransformationProvider(parameters);
        DatasetProcessor processor = new DatasetProcessor(datatypeFactory);
        this.checkSaveTransformation(parameters, transformation);
        try {
            processor.process(inputs, output, transformation.getTransformation(datatypeFactory), configuration);
        }
        catch (TransformationException e) {
            System.out.println("SedaCommand: ");
            e.printStackTrace();
        }
    }

    private void checkInputOptions(Parameters parameters) {
        if (!parameters.hasOption(OPTION_INPUT_DIRECTORY) ^ !parameters.hasOption(OPTION_INPUT_FILE) ^ !parameters.hasOption(OPTION_INPUT_LIST) ^ (parameters.hasOption(OPTION_INPUT_DIRECTORY) && parameters.hasOption(OPTION_INPUT_FILE) && parameters.hasOption(OPTION_INPUT_LIST))) {
            SedaCommand.validationError("An Input (file, directory or list) is mandatory");
        }
    }

    private Stream<Path> getInputPaths(Parameters parameters) throws IOException {
        if (parameters.hasOption(OPTION_INPUT_DIRECTORY)) {
            return this.getInputDirectory(parameters);
        }
        if (parameters.hasOption(OPTION_INPUT_FILE)) {
            return this.getInputFile(parameters);
        }
        if (parameters.hasOption(OPTION_INPUT_LIST)) {
            return this.getInputList(parameters);
        }
        throw new IllegalStateException("An input mode must be specified.");
    }

    private Stream<Path> getInputList(Parameters parameters) throws IOException {
        Path pathFile = parameters.getSingleValue(OPTION_INPUT_LIST).toPath();
        if (!Files.exists(pathFile, new LinkOption[0])) {
            SedaCommand.validationError("Invalid path. The path to the input list file must be valid and exist.");
        }
        return Files.lines(pathFile).filter(s -> Files.isRegularFile(Paths.get(s, new String[0]), new LinkOption[0])).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    private Stream<Path> getInputFile(Parameters parameters) throws IllegalArgumentException {
        List<File> fileList = parameters.getAllValues(OPTION_INPUT_FILE);
        if (fileList.stream().anyMatch(f -> !f.isFile())) {
            SedaCommand.validationError("Invalid path. The path to the input file must be valid and exist.");
        }
        return fileList.stream().map(File::toPath);
    }

    private Stream<Path> getInputDirectory(Parameters parameters) throws IOException {
        List fileList;
        Path inputPath = Paths.get(parameters.getSingleValueString(OPTION_INPUT_DIRECTORY), new String[0]);
        if (!Files.isDirectory(inputPath, new LinkOption[0])) {
            SedaCommand.validationError("Invalid path. The input directory must exist.");
        }
        if ((fileList = Files.list(inputPath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList())).isEmpty()) {
            SedaCommand.validationError("Invalid path. The input directory can't be empty.");
        }
        return fileList.stream();
    }

    private Path getOutputPath(Parameters parameters) {
        Path outputPath = Paths.get(parameters.getSingleValueString(OPTION_OUTPUT_DIRECTORY), new String[0]);
        if (Files.notExists(outputPath, new LinkOption[0])) {
            outputPath.toFile().mkdir();
        }
        return outputPath;
    }

    private DatasetProcessorConfiguration getConfiguration(Parameters parameters) {
        return new DatasetProcessorConfiguration(parameters.getSingleValue(OPTION_OUTPUT_GROUP_SIZE), parameters.hasOption(OPTION_OUTPUT_GZIP));
    }

    private DatatypeFactory getDatatypeFactory(Parameters parameters) {
        return parameters.hasOption(OPTION_DISK_PROCESSING) ? new InDiskDatatypeFactory() : DatatypeFactory.getDefaultDatatypeFactory();
    }

    private TransformationProvider getTransformationProvider(Parameters parameters) throws IOException {
        TransformationProvider transformation;
        if (parameters.hasOption(OPTION_PARAMETERS_FILE)) {
            File parameterFile = parameters.getSingleValue(OPTION_PARAMETERS_FILE);
            if (!parameterFile.isFile()) {
                SedaCommand.validationError("Invalid path. The parameters file must be valid and exist.");
            }
            transformation = this.getTransformation(parameterFile);
        } else {
            this.checkMandatoryOptions(parameters);
            transformation = this.getTransformation(parameters);
        }
        Validation validation = transformation.validate();
        if (!validation.isValid()) {
            SedaCommand.formattedValidationErrors(validation.getValidationErrors());
        }
        return transformation;
    }

    private void checkSaveTransformation(Parameters parameters, TransformationProvider transformation) throws IOException {
        if (parameters.hasOption(OPTION_SAVE_PARAMETERS_FILE)) {
            File parametersFile = parameters.getSingleValue(OPTION_SAVE_PARAMETERS_FILE);
            this.saveTransformation(transformation, parametersFile);
        }
    }

    protected static String formatValidationErrors(String ... errors) {
        return SedaCommand.formatValidationErrors(Arrays.asList(errors));
    }

    protected static String formatValidationErrors(List<String> validationErrors) {
        StringBuilder sb = new StringBuilder("The transformation is not valid: ");
        sb.append("\n\t - ").append(validationErrors.stream().collect(Collectors.joining("\n\t - ")));
        return sb.toString();
    }

    public static <E extends Enum<E>, T> E getEnumValue(Parameters parameters, Class<E> clazz, Option<T> enumOption) {
        String userInput = parameters.getSingleValueString(enumOption).toUpperCase();
        Optional<Enum> result = EnumSet.allOf(clazz).stream().filter(n -> n.name().equals(userInput)).findAny();
        if (result.isPresent()) {
            return (E)result.get();
        }
        SedaCommand.invalidEnumValue(enumOption);
        throw new IllegalStateException();
    }

    public static <T> void invalidEnumValue(Option<T> option) {
        SedaCommand.invalidOptionValue(option, "Invalid value for ");
    }

    public static double getDoubleValue(Parameters parameters, Option<String> stringOption) {
        try {
            return Double.valueOf(parameters.getSingleValue(stringOption));
        }
        catch (NumberFormatException ex) {
            SedaCommand.formattedValidationError("Invalid value for " + SedaCommand.formatParam(stringOption) + " (" + parameters.getSingleValue(stringOption) + "). It must be a number.");
            throw new IllegalStateException();
        }
    }

    public static <T> void invalidOptionValue(Option<T> option, String message) {
        SedaCommand.formattedValidationError(message + SedaCommand.formatParam(option) + ".\n\nOption description: " + option.getDescription());
    }

    public static void formattedValidationError(String error) {
        SedaCommand.validationError(SedaCommand.formatValidationErrors(error));
    }

    protected static void formattedValidationErrors(List<String> errors) {
        SedaCommand.validationError(SedaCommand.formatValidationErrors(errors));
    }

    private static void validationError(String message) {
        System.err.println(message);
        System.exit(1);
    }

    protected void checkMandatoryOptions(Parameters parameters) {
        List missingOptions = this.getMandatoryOptions().stream().filter(option -> !parameters.hasOption((Option<?>)option)).collect(Collectors.toList());
        if (!missingOptions.isEmpty()) {
            List<String> stringErrorList = missingOptions.stream().map(SedaCommand::formatMissingMandatoryOptionMessage).collect(Collectors.toList());
            SedaCommand.formattedValidationErrors(stringErrorList);
        }
    }

    protected int getIntegerFromStringOption(Parameters parameters, Option<String> option) {
        try {
            return Integer.valueOf(parameters.getSingleValue(option));
        }
        catch (NumberFormatException ex) {
            SedaCommand.formattedValidationError("Invalid value for " + SedaCommand.formatParam(option) + " (" + parameters.getSingleValue(option) + "). It must be a number.");
            throw new IllegalStateException();
        }
    }

    protected File getExistingFile(Parameters parameters, FileOption fileOption) {
        File queryFile = parameters.getSingleValue(fileOption);
        if (queryFile.exists()) {
            return queryFile;
        }
        SedaCommand.formattedValidationError("Invalid path. The path specified in " + SedaCommand.formatParam(fileOption) + " must be valid and exist.");
        throw new IllegalStateException();
    }

    protected List<Option<?>> getMandatoryOptions() {
        return Collections.emptyList();
    }

    protected abstract List<Option<?>> createSedaOptions();

    protected abstract TransformationProvider getTransformation(Parameters var1);

    protected abstract TransformationProvider getTransformation(File var1) throws IOException;

    protected void saveTransformation(TransformationProvider provider, File file) throws IOException {
        new JsonObjectWriter<TransformationProvider>().write(provider, file);
    }

    public static <T> void checkMandatoryOption(Parameters parameters, Option<T> option) {
        if (!parameters.hasOption(option)) {
            SedaCommand.validationError(SedaCommand.formatMissingMandatoryOptionMessage(option));
        }
    }

    protected static <T> String formatMissingMandatoryOptionMessage(Option<T> option) {
        StringBuilder sb = new StringBuilder("Missing parameter: ");
        sb.append(SedaCommand.formatParam(option)).append(" is mandatory.");
        return sb.toString();
    }

    public static <T> String formatParam(Option<T> option) {
        StringBuilder sb = new StringBuilder();
        sb.append("--").append(option.getParamName()).append("/-").append(option.getShortName());
        return sb.toString();
    }

    protected abstract String getSedaGroup();
}

