/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input.text;

import java.awt.Color;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.utilities.ColorUtils;

public class EmailJXTextField
extends JXTextField {
    private static final long serialVersionUID = 1L;
    private static final Color COLOR_VALID_INPUT = UIManager.getColor("TextField.background");
    protected Color invalidEmailColor;
    private boolean allowEmpty;
    private boolean textChangedDocumenListenerAdded = false;
    private DocumentListener textChangedDocumentListener = new DocumentAdapter(){

        @Override
        public void removeUpdate(DocumentEvent e) {
            EmailJXTextField.this.textChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            EmailJXTextField.this.textChanged();
        }
    };

    public EmailJXTextField() {
        this(ColorUtils.COLOR_INVALID_INPUT, false);
    }

    public EmailJXTextField(Color invalidEmailColor, boolean allowEmpty) {
        super("your@email.com");
        this.allowEmpty = allowEmpty;
        this.invalidEmailColor = invalidEmailColor;
        this.addTextChangedDocumentListener();
        this.textChanged();
    }

    private void addTextChangedDocumentListener() {
        if (!this.textChangedDocumenListenerAdded) {
            this.getDocument().addDocumentListener(this.textChangedDocumentListener);
            this.textChangedDocumenListenerAdded = true;
        }
    }

    private void textChanged() {
        if (!this.isValidInput()) {
            this.setBackground(this.invalidEmailColor);
        } else {
            this.setBackground(COLOR_VALID_INPUT);
        }
    }

    private static boolean isEmailValid(String email) {
        Pattern EMAIL_REGEX = Pattern.compile("[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?", 2);
        return EMAIL_REGEX.matcher(email).matches();
    }

    public boolean isValidInput() {
        String email = this.getText();
        return (email.isEmpty() || EmailJXTextField.isEmailValid(email)) && (!email.isEmpty() || this.allowEmpty);
    }
}

