/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.input;

import java.awt.Color;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.sing_group.gc4s.event.TextFieldSelectionFocusListener;
import org.sing_group.gc4s.input.DoubleRange;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.text.DoubleTextField;
import org.sing_group.gc4s.utilities.ColorUtils;

public class DoubleRangeInputPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_RANGE = "value";
    public static final Color COLOR_VALID_INPUT = UIManager.getColor("TextField.background");
    private static final String MINIMUM_VALUE = "Minimum value";
    private static final String MAXIMUM_VALUE = "Maximum value";
    private DoubleRange range;
    private PropertyChangeListener listener = this::rangeChanged;
    private FocusListener focusListener = new TextFieldSelectionFocusListener();
    private DoubleTextField minRangeValue;
    private DoubleTextField maxRangeValue;

    public DoubleRangeInputPanel() {
        this(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public DoubleRangeInputPanel(double min, double max) {
        this(new DoubleRange(min, max));
    }

    public DoubleRangeInputPanel(DoubleRange range) {
        this.range = range;
        this.init();
    }

    private void init() {
        this.add(new InputParametersPanel(this.getParameters()));
    }

    private InputParameter[] getParameters() {
        InputParameter[] parameters = new InputParameter[]{new InputParameter(MINIMUM_VALUE, this.getMinimumValueInput(), MINIMUM_VALUE), new InputParameter(MAXIMUM_VALUE, this.getMaximumValueInput(), MAXIMUM_VALUE)};
        return parameters;
    }

    private JComponent getMinimumValueInput() {
        this.minRangeValue = new DoubleTextField(this.range.getMin());
        this.minRangeValue.addPropertyChangeListener(PROPERTY_RANGE, this.listener);
        this.minRangeValue.addFocusListener(this.focusListener);
        this.minRangeValue.setColumns(10);
        return this.minRangeValue;
    }

    private JComponent getMaximumValueInput() {
        this.maxRangeValue = new DoubleTextField(this.range.getMax());
        this.maxRangeValue.addPropertyChangeListener(PROPERTY_RANGE, this.listener);
        this.maxRangeValue.addFocusListener(this.focusListener);
        this.maxRangeValue.setColumns(10);
        return this.maxRangeValue;
    }

    private void checkRangeValues() {
        boolean validRange = this.isValidRange();
        this.setRangeTextFieldColor(validRange);
    }

    private void setRangeTextFieldColor(boolean validValues) {
        Color backgroundColor = this.getTextFieldBackgroundColor(validValues);
        this.minRangeValue.setBackground(backgroundColor);
        this.maxRangeValue.setBackground(backgroundColor);
    }

    private Color getTextFieldBackgroundColor(boolean validValues) {
        return validValues ? COLOR_VALID_INPUT : ColorUtils.COLOR_INVALID_INPUT;
    }

    public boolean isValidRange() {
        return this.getMinValue() < this.getMaxValue();
    }

    private double getMinValue() {
        return this.minRangeValue.getValue();
    }

    private double getMaxValue() {
        return this.maxRangeValue.getValue();
    }

    public DoubleRange getRange() {
        return this.range;
    }

    public void setRange(DoubleRange range) {
        this.range = range;
        this.minRangeValue.setValue(range.getMin());
        this.maxRangeValue.setValue(range.getMax());
    }

    private void rangeChanged(PropertyChangeEvent e) {
        DoubleRange newRange = new DoubleRange(this.getMinValue(), this.getMaxValue());
        this.firePropertyChange(PROPERTY_RANGE, this.getRange(), newRange);
        this.range = newRange;
        this.checkRangeValues();
    }
}

