/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.commons.csv.entities;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;

public class CsvFormat
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String lineBreak;
    private String columnSeparator;
    private boolean quoteFields;
    private char decimalSeparator = (char)46;
    private final DecimalFormat decimalFormatter = new DecimalFormat("0.0000");
    private final DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());

    public CsvFormat(String columnSeparator, char decimalSeparator, boolean quoteFields, String lineBreak) {
        this.columnSeparator = columnSeparator;
        this.lineBreak = lineBreak;
        this.quoteFields = quoteFields;
        this.decimalSeparator = decimalSeparator;
        this.configureFormaters();
    }

    private void configureFormaters() {
        if (this.decimalSeparator != this.symbols.getDecimalSeparator()) {
            this.symbols.setDecimalSeparator(this.decimalSeparator);
            this.decimalFormatter.setDecimalFormatSymbols(this.symbols);
        }
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public DecimalFormat getDecimalFormatter() {
        return this.decimalFormatter;
    }

    public String getLineBreak() {
        return this.lineBreak;
    }

    public void setDecimalFormatterMaximumFractionDigits(int newValue) {
        this.decimalFormatter.setMaximumFractionDigits(newValue);
    }

    public boolean isQuoteFields() {
        return this.quoteFields;
    }

    public double asDouble(String number) throws ParseException {
        return this.getDecimalFormatter().parse(this.fixString(number)).doubleValue();
    }

    private String fixString(String number) {
        return number.replace("e", "E");
    }

    public boolean equals(Object aThat) {
        if (aThat == null) {
            return false;
        }
        if (!(aThat instanceof CsvFormat)) {
            return false;
        }
        CsvFormat that = (CsvFormat)aThat;
        return this.quoteFields == that.quoteFields && this.columnSeparator.equals(that.columnSeparator) && this.decimalSeparator == that.decimalSeparator && this.lineBreak.equals(that.lineBreak);
    }
}

