/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.transformation.dataset;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.sing_group.seda.blast.datatype.TwoWayBlastMode;
import org.sing_group.seda.blast.datatype.blast.BlastType;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.transformation.dataset.TwoWayBlastTransformation;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.transformation.TransformationException;

public class TwoWayBlastTransformationBuilder {
    private TwoWayBlastMode mode;
    private BlastType blastType;
    private File queryFile;
    private double eValue = 0.05;
    private File databasesDirectory = null;
    private BlastBinariesExecutor blastBinariesExecutor;
    private DatatypeFactory factory = DatatypeFactory.getDefaultDatatypeFactory();
    private String blastAdditionalParameters = "";
    private int numThreads = 1;

    public TwoWayBlastTransformationBuilder(BlastType blastType, File queryFile, TwoWayBlastMode mode) {
        this.blastType = blastType;
        this.queryFile = queryFile;
        this.mode = mode;
    }

    public TwoWayBlastTransformationBuilder withEvalue(double eValue) {
        this.eValue = eValue;
        return this;
    }

    public TwoWayBlastTransformationBuilder withDatabasesDirectory(File databasesDirectory) {
        this.databasesDirectory = databasesDirectory;
        return this;
    }

    public TwoWayBlastTransformationBuilder withBlastBinariesExecutor(BlastBinariesExecutor blastBinariesExecutor) {
        this.blastBinariesExecutor = blastBinariesExecutor;
        return this;
    }

    public TwoWayBlastTransformationBuilder withDatatypeFactory(DatatypeFactory factory) {
        this.factory = factory;
        return this;
    }

    public TwoWayBlastTransformationBuilder withBlastAditionalParameters(String blastAdditionalParameters) {
        this.blastAdditionalParameters = blastAdditionalParameters;
        return this;
    }

    public TwoWayBlastTransformationBuilder withNumThreads(int numThreads) {
        this.numThreads = numThreads;
        return this;
    }

    public TwoWayBlastTransformation build() {
        try {
            return new TwoWayBlastTransformation(this.blastType, this.mode, this.blastBinariesExecutor, this.queryFile, this.getDatabasesDirectory(), this.eValue, this.blastAdditionalParameters, this.numThreads, this.factory);
        }
        catch (IOException e) {
            throw new TransformationException(e);
        }
    }

    private File getDatabasesDirectory() throws IOException {
        return this.databasesDirectory == null ? Files.createTempDirectory("seda-blastdb", new FileAttribute[0]).toFile() : this.databasesDirectory;
    }
}

