/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.ncbi;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.sing_group.seda.blast.ncbi.NcbiBlastRequestStatus;

public class NcbiBlastRequestPageParser {
    public static String getRequestId(String response) throws IOException {
        Document document = Jsoup.parse((String)response);
        String requestId = document.getElementById("rid").attr("value");
        if (!requestId.trim().isEmpty()) {
            return requestId;
        }
        Elements errorElements = document.getElementsByClass("error");
        StringBuilder exceptionMessage = new StringBuilder("Request ID not found");
        errorElements.forEach(e -> {
            if (e.tagName().equals("p")) {
                exceptionMessage.append(": ").append(e.html());
            }
        });
        throw new IOException(exceptionMessage.toString());
    }

    public static NcbiBlastRequestStatus getRequestStatus(String response) throws IOException {
        NcbiBlastRequestStatus status = NcbiBlastRequestStatus.UNKNOWN;
        for (String qBlastInfo : NcbiBlastRequestPageParser.getQBlastInfoComments(response)) {
            if (qBlastInfo.contains("Status=WAITING")) {
                return NcbiBlastRequestStatus.WAITING;
            }
            if (qBlastInfo.contains("Status=FAILED")) {
                return NcbiBlastRequestStatus.FAILED;
            }
            if (qBlastInfo.contains("Status=UNKNOWN")) {
                return NcbiBlastRequestStatus.UNKNOWN;
            }
            if (qBlastInfo.contains("Status=READY")) {
                status = NcbiBlastRequestStatus.READY;
                continue;
            }
            if (!qBlastInfo.contains("ThereAreHits=yes")) continue;
            return NcbiBlastRequestStatus.READY_WITH_HITS;
        }
        return status;
    }

    private static List<String> getQBlastInfoComments(String response) {
        Document document = Jsoup.parse((String)response);
        LinkedList<String> comments = new LinkedList<String>();
        for (Element e : document.getAllElements()) {
            for (Node n : e.childNodes()) {
                if (!(n instanceof Comment) || !((Comment)n).getData().contains("QBlastInfoBegin")) continue;
                comments.add(((Comment)n).getData());
            }
        }
        return comments;
    }
}

