/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.event.RunnableDocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.RadioButtonsPanel;
import org.sing_group.gc4s.input.combobox.ExtendedJComboBox;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanelBuilder;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.gc4s.input.text.DoubleTextField;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.blast.datatype.DatabaseQueryMode;
import org.sing_group.seda.blast.datatype.SequenceType;
import org.sing_group.seda.blast.datatype.blast.BlastType;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.gui.BlastExecutionConfigurationPanel;
import org.sing_group.seda.blast.plugin.core.BlastSedaPluginInfo;
import org.sing_group.seda.blast.transformation.provider.blast.BlastTransformationProvider;
import org.sing_group.seda.core.SedaContext;
import org.sing_group.seda.core.SedaContextEvent;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;

public class BlastTransformationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_SEQ_TYPE = "The type of the sequences in the database. This is automatically selected based on the BLAST command to execute.";
    private static final String HELP_FILE_QUERY_COMBO = BlastTransformationConfigurationPanel.html("When <i>" + (Object)((Object)QueryType.INTERNAL) + "</i> is selected, the input file whose sequences must be used for the BLAST queries.");
    private static final String HELP_QUERY_FILE = BlastTransformationConfigurationPanel.html("When <i>" + (Object)((Object)QueryType.EXTERNAL) + "</i> is selected, the file that contains the sequences that must be used for the BLAST queries.");
    private BlastTransformationProvider transformationProvider;
    private SedaContext context;
    private JCheckBox storeDatabases;
    private JCheckBox storeAlias;
    private JFileChooserPanel databasesDirectory;
    private JFileChooserPanel aliasFile;
    private RadioButtonsPanel<QueryType> queryTypeRadioButtonsPanel;
    private ExtendedJComboBox<String> fileQueryCombobox;
    private DefaultComboBoxModel<String> fileQueryComboboxModel;
    private JFileChooserPanel fileQuery;
    private RadioButtonsPanel<SequenceType> sequenceTypeRbtnPanel;
    private JComboBox<BlastType> blastTypeCombobox;
    private RadioButtonsPanel<DatabaseQueryMode> databaseQueryModeRadioButtonsPanel;
    private DoubleTextField eValue;
    private JIntegerTextField maxTargetSeqs;
    private JXTextField additionalBlastParameters;
    private JCheckBox extractOnlyHitRegions;
    private JIntegerTextField hitRegionsWindowSize;
    private BlastExecutionConfigurationPanel blastExecutionConfigurationPanel;

    private static final String html(String string) {
        return "<html>" + string + "</html>";
    }

    public BlastTransformationConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void initTransformationProvider() {
        this.transformationProvider = new BlastTransformationProvider((DatabaseQueryMode)((Object)this.databaseQueryModeRadioButtonsPanel.getSelectedItem().get()), (BlastType)((Object)this.blastTypeCombobox.getSelectedItem()), this.eValue.getValue(), this.maxTargetSeqs.getValue(), this.isExtractOnlyHitRegions(), this.hitRegionsWindowSize.getValue());
        this.blastExecutorChanged();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add((Component)this.getBlastConfigurationPanel());
        mainPanel.add((Component)this.getDatabaseConfigurationPanel());
        mainPanel.add((Component)this.getQueryConfigurationPanel());
        return new CenteredJPanel((Component)mainPanel);
    }

    private InputParametersPanel getBlastConfigurationPanel() {
        InputParametersPanel blastConfigurationPanel = new InputParametersPanel(this.getBlastParameters());
        blastConfigurationPanel.setBorder((Border)BorderFactory.createTitledBorder("BLAST configuration"));
        return blastConfigurationPanel;
    }

    private InputParameter getBlastExecutableParameter() {
        this.blastExecutionConfigurationPanel = new BlastExecutionConfigurationPanel(this::blastExecutorChanged);
        return new InputParameter("", (JComponent)this.blastExecutionConfigurationPanel, "The mode to execute BLAST.");
    }

    private void blastExecutorChanged(BinaryExecutionConfigurationPanel<BlastBinariesExecutor> source) {
        this.blastExecutorChanged();
    }

    private void blastExecutorChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setBlastBinariesExecutor(this.blastExecutionConfigurationPanel.getBinariesExecutor()));
    }

    private InputParameter[] getBlastParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getBlastExecutableParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParametersPanel getDatabaseConfigurationPanel() {
        InputParametersPanel dbConfigurationPanel = new InputParametersPanel(this.getDbParameters());
        dbConfigurationPanel.setBorder((Border)BorderFactory.createTitledBorder("DB configuration"));
        return dbConfigurationPanel;
    }

    private InputParameter[] getDbParameters() {
        LinkedList<InputParameter> dbParameters = new LinkedList<InputParameter>();
        dbParameters.add(this.getSequenceTypeParameter());
        dbParameters.add(this.getStoreDatabasesParameter());
        dbParameters.add(this.getDatabasesDirectoryParameter());
        dbParameters.add(this.getStoreAliasParameter());
        dbParameters.add(this.getAliasFileParameter());
        this.checkDatabaseFileChooser();
        this.checkAliasFileChooser();
        return dbParameters.toArray(new InputParameter[dbParameters.size()]);
    }

    private InputParameter getSequenceTypeParameter() {
        this.sequenceTypeRbtnPanel = new RadioButtonsPanel((Object[])SequenceType.values(), 1, 0);
        this.sequenceTypeRbtnPanel.setEnabled(false);
        return new InputParameter("Sequence type: ", this.sequenceTypeRbtnPanel, HELP_SEQ_TYPE);
    }

    private InputParametersPanel getQueryConfigurationPanel() {
        InputParametersPanel queryConfigurationPanel = new InputParametersPanel(this.getParameters());
        queryConfigurationPanel.setBorder((Border)BorderFactory.createTitledBorder("Query configuration"));
        return queryConfigurationPanel;
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getDatabaseQueryModeParameter());
        parameters.add(this.getBlastTypeParameter());
        parameters.add(this.getQueryTypeParameter());
        parameters.add(this.getFileQueryParameter());
        parameters.add(this.getExternalFileQueryParameter());
        parameters.add(this.getEvalueParameter());
        parameters.add(this.getMaxTargetSeqsParameter());
        parameters.add(this.getAdditionalBlastParamsParameter());
        parameters.add(this.getExtractOnlyHitRegionsParamsParameter());
        parameters.add(this.getHitRegionsWindowSizeParamsParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getDatabaseQueryModeParameter() {
        this.databaseQueryModeRadioButtonsPanel = new RadioButtonsPanel((Object[])DatabaseQueryMode.values(), 1, 0);
        this.databaseQueryModeRadioButtonsPanel.addItemListener(this::databaseQueryModeChanged);
        return new InputParameter("Query against: ", this.databaseQueryModeRadioButtonsPanel, BlastSedaPluginInfo.PARAM_DATABASE_QUERY_MODE_HELP_GUI);
    }

    private void databaseQueryModeChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            SwingUtilities.invokeLater(() -> this.transformationProvider.setDatabaseQueryMode(this.getDatabaseQueryMode()));
            this.storeAliasChanged();
            SwingUtilities.invokeLater(this::checkDatabaseQueryMode);
        }
    }

    private DatabaseQueryMode getDatabaseQueryMode() {
        return (DatabaseQueryMode)((Object)this.databaseQueryModeRadioButtonsPanel.getSelectedItem().get());
    }

    private InputParameter getQueryTypeParameter() {
        this.queryTypeRadioButtonsPanel = new RadioButtonsPanel((Object[])QueryType.values(), 1, 0);
        this.queryTypeRadioButtonsPanel.addItemListener(this::queryTypeChanged);
        return new InputParameter("Query source: ", this.queryTypeRadioButtonsPanel, "The source of the query sequences.");
    }

    private void queryTypeChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.queryFileChanged();
        }
        SwingUtilities.invokeLater(this::checkQuerySelection);
    }

    private void queryFileChanged() {
        SwingUtilities.invokeLater(() -> {
            Optional<File> queryFile = this.getQueryFile();
            if (queryFile.isPresent()) {
                this.transformationProvider.setQueryFile(queryFile.get());
            } else {
                this.transformationProvider.clearQueryFile();
            }
        });
    }

    private InputParameter getBlastTypeParameter() {
        this.blastTypeCombobox = new JComboBox<BlastType>(BlastType.values());
        this.blastTypeCombobox.addItemListener(this::blastTypeChanged);
        return new InputParameter("BLAST type: ", this.blastTypeCombobox, BlastSedaPluginInfo.PARAM_QUERY_BLAST_TYPE_HELP_GUI);
    }

    private void blastTypeChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.sequenceTypeRbtnPanel.setSelectedItem((Object)this.getBlastType().getDatabaseType());
            this.checkQuerySelection();
            SwingUtilities.invokeLater(() -> this.transformationProvider.setBlastType(this.getBlastType()));
        }
    }

    private void checkDatabaseQueryMode() {
        boolean enabled = this.getDatabaseQueryMode().equals((Object)DatabaseQueryMode.ALL);
        this.storeAlias.setEnabled(enabled);
        this.checkAliasFileChooser();
    }

    private void checkQuerySelection() {
        boolean disabled;
        BlastType selectedBlastType = this.getBlastType();
        boolean bl = disabled = selectedBlastType.equals((Object)BlastType.BLASTX) || selectedBlastType.equals((Object)BlastType.TBLASTN);
        if (disabled) {
            this.queryTypeRadioButtonsPanel.setSelectedItem((Object)QueryType.EXTERNAL);
        }
        this.fileQueryCombobox.setEnabled(!this.isExternalQueryFile());
    }

    private BlastType getBlastType() {
        return (BlastType)((Object)this.blastTypeCombobox.getSelectedItem());
    }

    private InputParameter getStoreDatabasesParameter() {
        this.storeDatabases = new JCheckBox();
        this.storeDatabases.addItemListener(this::storeDatabasesChanged);
        return new InputParameter("Store databases:", (JComponent)this.storeDatabases, BlastSedaPluginInfo.PARAM_STORE_DATABASES_HELP_GUI);
    }

    private void storeDatabasesChanged(ItemEvent event) {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setStoreDatabases(this.storeDatabases.isSelected()));
        SwingUtilities.invokeLater(this::checkDatabaseFileChooser);
    }

    private void checkDatabaseFileChooser() {
        boolean enabled = this.storeDatabases.isEnabled() && this.storeDatabases.isSelected();
        this.databasesDirectory.getBrowseAction().setEnabled(enabled);
    }

    private InputParameter getStoreAliasParameter() {
        this.storeAlias = new JCheckBox();
        this.storeAlias.addItemListener(e -> this.storeAliasChanged());
        return new InputParameter("Store alias:", (JComponent)this.storeAlias, "Whether the database alias must be stored or not.");
    }

    private void storeAliasChanged() {
        this.transformationProvider.setStoreAlias(this.isStoreAlias());
        SwingUtilities.invokeLater(this::checkAliasFileChooser);
    }

    private void checkAliasFileChooser() {
        boolean enabled = this.storeAlias.isSelected() && this.storeAlias.isEnabled();
        this.aliasFile.getBrowseAction().setEnabled(enabled);
    }

    private InputParameter getDatabasesDirectoryParameter() {
        this.databasesDirectory = JFileChooserPanelBuilder.createSaveJFileChooserPanel().withFileChooser(CommonFileChooser.getInstance().getFilechooser()).withFileChooserSelectionMode(SelectionMode.DIRECTORIES).withLabel("").withClearSelectedFileOnShow(true).build();
        this.databasesDirectory.addFileChooserListener(this::databasesDirectoryChanged);
        return new InputParameter("Databases directory:", (JComponent)this.databasesDirectory, BlastSedaPluginInfo.PARAM_STORE_DATABASES_DIRECTORY_HELP_GUI);
    }

    private void databasesDirectoryChanged(ChangeEvent event) {
        SwingUtilities.invokeLater(() -> {
            File databasesDirectory = this.databasesDirectory.getSelectedFile();
            if (databasesDirectory == null) {
                this.transformationProvider.clearDatabasesDirectory();
            } else {
                this.transformationProvider.setDatabasesDirectory(databasesDirectory);
            }
        });
    }

    private InputParameter getAliasFileParameter() {
        this.aliasFile = JFileChooserPanelBuilder.createSaveJFileChooserPanel().withFileChooser(CommonFileChooser.getInstance().getFilechooser()).withFileChooserSelectionMode(SelectionMode.FILES).withLabel("").withClearSelectedFileOnShow(true).build();
        this.aliasFile.addFileChooserListener(this::aliasFileChanged);
        return new InputParameter("Alias file:", (JComponent)this.aliasFile, "The file where the alias must be stored.");
    }

    private void aliasFileChanged(ChangeEvent event) {
        SwingUtilities.invokeLater(() -> {
            File aliasFile = this.aliasFile.getSelectedFile();
            if (aliasFile == null) {
                this.transformationProvider.clearAliasFile();
            } else {
                this.transformationProvider.setAliasFile(aliasFile);
            }
        });
    }

    private InputParameter getFileQueryParameter() {
        this.fileQueryComboboxModel = new DefaultComboBoxModel();
        this.fileQueryCombobox = new ExtendedJComboBox(this.fileQueryComboboxModel);
        this.fileQueryCombobox.addItemListener(this::queryChanged);
        this.fileQueryCombobox.setPrototypeDisplayValue((Object)"");
        this.updateFileQueryComboboxUi();
        return new InputParameter("File query:", this.fileQueryCombobox, HELP_FILE_QUERY_COMBO);
    }

    private void queryChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.queryFileChanged();
            this.fileQueryCombobox.setToolTipText(this.fileQueryCombobox.getSelectedItem().toString());
        }
    }

    private InputParameter getExternalFileQueryParameter() {
        this.fileQuery = JFileChooserPanelBuilder.createOpenJFileChooserPanel().withFileChooser(CommonFileChooser.getInstance().getFilechooser()).withFileChooserSelectionMode(SelectionMode.FILES).withLabel("").withClearSelectedFileOnShow(true).build();
        this.fileQuery.addFileChooserListener(this::externalFileQueryChanged);
        return new InputParameter("External file query:", (JComponent)this.fileQuery, HELP_QUERY_FILE);
    }

    private void externalFileQueryChanged(ChangeEvent event) {
        this.queryFileChanged();
    }

    private InputParameter getEvalueParameter() {
        this.eValue = new DoubleTextField(0.05);
        this.eValue.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::eValueChanged));
        return new InputParameter("Expectation value:", (JComponent)this.eValue, "The expectation value (E) threshold for saving hits.");
    }

    private void eValueChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setEvalue(this.eValue.getValue()));
    }

    private InputParameter getMaxTargetSeqsParameter() {
        this.maxTargetSeqs = new JIntegerTextField(Integer.valueOf(500000));
        this.maxTargetSeqs.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::maxTargetSeqsChanged));
        return new InputParameter("Max. target seqs.:", (JComponent)this.maxTargetSeqs, "The maximum number of aligned sequences to keep.");
    }

    private void maxTargetSeqsChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setMaxTargetSeqs(this.maxTargetSeqs.getValue()));
    }

    private InputParameter getAdditionalBlastParamsParameter() {
        this.additionalBlastParameters = new JXTextField("Additional parameters for BLAST");
        this.additionalBlastParameters.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::additionaParametersChanged));
        return new InputParameter("Additional parameters:", (JComponent)this.additionalBlastParameters, "Additional parameters for the BLAST command.");
    }

    private void additionaParametersChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setAdditionalParameters(this.additionalBlastParameters.getText()));
    }

    private InputParameter getExtractOnlyHitRegionsParamsParameter() {
        this.extractOnlyHitRegions = new JCheckBox();
        this.extractOnlyHitRegions.addItemListener(this::extractOnlyHiyRegionsChanged);
        return new InputParameter("Extract only hit regions:", (JComponent)this.extractOnlyHitRegions, "Use this option to extract only the part of the sequences where hits are produced instead of the entire subject sequences.");
    }

    private void extractOnlyHiyRegionsChanged(ItemEvent event) {
        this.hitRegionsWindowSize.setEnabled(this.isExtractOnlyHitRegions());
        SwingUtilities.invokeLater(() -> this.transformationProvider.setExtractOnlyHitRegions(this.isExtractOnlyHitRegions()));
    }

    private boolean isExtractOnlyHitRegions() {
        return this.extractOnlyHitRegions.isSelected();
    }

    private InputParameter getHitRegionsWindowSizeParamsParameter() {
        this.hitRegionsWindowSize = new JIntegerTextField(Integer.valueOf(0));
        this.hitRegionsWindowSize.setEnabled(this.isExtractOnlyHitRegions());
        this.hitRegionsWindowSize.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(this::hitRegionsWindowSizeChanged));
        return new InputParameter("Hit regions window:", (JComponent)this.hitRegionsWindowSize, "The window size to retrieve only hit regions.");
    }

    private void hitRegionsWindowSizeChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setHitRegionsWindowSize(this.hitRegionsWindowSize.getValue()));
    }

    public BlastTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setSedaContext(SedaContext context) {
        this.context = context;
        this.context.addSedaContextListener(this::contextChanged);
    }

    private void contextChanged(SedaContextEvent event) {
        if (event.getType().equals((Object)SedaContextEvent.SedaContextEventType.SELECTED_PATHS_CHANGED)) {
            this.selectedPathsChanged();
        }
    }

    private void selectedPathsChanged() {
        this.fileQueryComboboxModel.removeAllElements();
        List<String> selectedPaths = this.context.getSelectedPaths();
        if (!selectedPaths.isEmpty()) {
            selectedPaths.forEach(p -> this.fileQueryComboboxModel.addElement((String)p));
        }
        this.updateFileQueryComboboxUi();
    }

    private void updateFileQueryComboboxUi() {
        this.fileQueryCombobox.setPreferredSize(new Dimension(200, 20));
        this.fileQueryCombobox.setAutoAdjustWidth(true);
        this.fileQueryCombobox.updateUI();
    }

    private Optional<File> getQueryFile() {
        if (this.isExternalQueryFile()) {
            return Optional.ofNullable(this.fileQuery.getSelectedFile());
        }
        if (this.fileQueryCombobox.getSelectedIndex() == -1) {
            return Optional.empty();
        }
        return Optional.of(new File(this.fileQueryCombobox.getSelectedItem().toString()));
    }

    private boolean isExternalQueryFile() {
        return ((QueryType)((Object)this.queryTypeRadioButtonsPanel.getSelectedItem().get())).equals((Object)QueryType.EXTERNAL);
    }

    private boolean isStoreAlias() {
        return this.getDatabaseQueryMode().equals((Object)DatabaseQueryMode.ALL) && this.storeAlias.isSelected();
    }

    public void setTransformationProvider(BlastTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        if (this.transformationProvider.getBlastBinariesExecutor() != null) {
            this.blastExecutionConfigurationPanel.setBinariesExecutor(this.transformationProvider.getBlastBinariesExecutor());
        }
        this.storeDatabases.setSelected(this.transformationProvider.isStoreDatabases());
        File databasesDirectory = this.transformationProvider.getDatabasesDirectory();
        if (databasesDirectory == null) {
            this.databasesDirectory.clearSelectedFile();
        } else {
            this.databasesDirectory.setSelectedFile(databasesDirectory);
        }
        this.storeAlias.setSelected(this.transformationProvider.isStoreAlias());
        File aliasFile = this.transformationProvider.getAliasFile();
        if (aliasFile == null) {
            this.aliasFile.clearSelectedFile();
        } else {
            this.aliasFile.setSelectedFile(aliasFile);
        }
        if (this.transformationProvider.getDatabaseQueryMode() != null) {
            this.databaseQueryModeRadioButtonsPanel.setSelectedItem((Object)this.transformationProvider.getDatabaseQueryMode());
        }
        if (this.transformationProvider.getBlastType() != null) {
            this.blastTypeCombobox.setSelectedItem((Object)this.transformationProvider.getBlastType());
        }
        if (this.transformationProvider.getQueryFile() != null) {
            this.fileQuery.setSelectedFile(this.transformationProvider.getQueryFile());
            this.queryTypeRadioButtonsPanel.setSelectedItem((Object)QueryType.EXTERNAL);
        } else {
            this.fileQuery.clearSelectedFile();
        }
        this.eValue.setValue((Object)this.transformationProvider.geteValue());
        this.maxTargetSeqs.setValue((Object)this.transformationProvider.getMaxTargetSeqs());
        this.additionalBlastParameters.setText(this.transformationProvider.getAdditionalParameters());
        this.extractOnlyHitRegions.setSelected(this.transformationProvider.isExtractOnlyHitRegions());
        this.hitRegionsWindowSize.setValue((Object)this.transformationProvider.getHitRegionsWindowSize());
    }

    private static enum QueryType {
        INTERNAL("From selected file"),
        EXTERNAL("From external file");

        private String description;

        private QueryType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

