/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.emboss.transformation.provider;

import java.util.LinkedList;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.emboss.execution.EmbossBinariesExecutor;
import org.sing_group.seda.emboss.getorf.datatype.FindParam;
import org.sing_group.seda.emboss.getorf.datatype.TableParam;
import org.sing_group.seda.emboss.transformation.provider.GetOrfTransformationConfigurationChangeType;
import org.sing_group.seda.emboss.transformation.sequencesgroup.GetOrfSequencesGroupTransformation;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

@XmlRootElement
public class GetOrfTransformationProvider
extends AbstractTransformationProvider {
    @XmlAnyElement(lax=true)
    private EmbossBinariesExecutor embossBinariesExecutor;
    @XmlElement
    private TableParam table;
    @XmlElement
    private int minSize;
    @XmlElement
    private int maxSize;
    @XmlElement
    private FindParam find;
    @XmlElement
    private String additionalParameters;

    public GetOrfTransformationProvider() {
    }

    public GetOrfTransformationProvider(TableParam table, FindParam find, Integer minSize, Integer maxSize, String additionalParameters) {
        this.table = table;
        this.find = find;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.additionalParameters = additionalParameters;
    }

    @Override
    public Validation validate() {
        try {
            LinkedList<String> validationErrors = new LinkedList<String>();
            if (this.table == null) {
                validationErrors.add("The table can't be null");
            }
            if (this.find == null) {
                validationErrors.add("The table can't be null");
            }
            if (!this.isValidEmbossBinariesExecutor()) {
                validationErrors.add("The EMBOSS binaries executor is not valid");
            }
            if (validationErrors.isEmpty()) {
                this.getEmbossTransformation(DatatypeFactory.getDefaultDatatypeFactory());
                return new DefaultValidation(new String[0]);
            }
            return new DefaultValidation(validationErrors);
        }
        catch (RuntimeException ex) {
            return new DefaultValidation(ex.toString());
        }
    }

    private boolean isValidEmbossBinariesExecutor() {
        if (this.embossBinariesExecutor == null) {
            return false;
        }
        try {
            this.embossBinariesExecutor.checkBinary();
            return true;
        }
        catch (BinaryCheckException e) {
            return false;
        }
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return new ComposedSequencesGroupDatasetTransformation(this.getEmbossTransformation(factory));
    }

    private GetOrfSequencesGroupTransformation getEmbossTransformation(DatatypeFactory factory) {
        return new GetOrfSequencesGroupTransformation(factory, this.embossBinariesExecutor, this.table.getParamValue(), this.minSize, this.maxSize, this.find.getParamValue(), this.additionalParameters == null ? "" : this.additionalParameters);
    }

    public void setEmbossBinariesExecutor(Optional<EmbossBinariesExecutor> embossBinariesExecutor) {
        this.embossBinariesExecutor = embossBinariesExecutor.orElse(null);
        this.fireTransformationsConfigurationModelEvent(GetOrfTransformationConfigurationChangeType.EMBOSS_EXECUTOR_CHANGED, this.embossBinariesExecutor);
    }

    public EmbossBinariesExecutor getEmbossBinariesExecutor() {
        return this.embossBinariesExecutor;
    }

    public void setTable(TableParam table) {
        if (this.table == null || !this.table.equals((Object)table)) {
            this.table = table;
            this.fireTransformationsConfigurationModelEvent(GetOrfTransformationConfigurationChangeType.TABLE_CHANGED, (Object)this.table);
        }
    }

    public TableParam getTable() {
        return this.table;
    }

    public void setFind(FindParam find) {
        if (this.find == null || !this.find.equals((Object)find)) {
            this.find = find;
            this.fireTransformationsConfigurationModelEvent(GetOrfTransformationConfigurationChangeType.FIND_CHANGED, (Object)this.find);
        }
    }

    public FindParam getFind() {
        return this.find;
    }

    public void setMinSize(int minSize) {
        if (this.minSize != minSize) {
            this.minSize = minSize;
            this.fireTransformationsConfigurationModelEvent(GetOrfTransformationConfigurationChangeType.MINSIZE_CHANGED, this.minSize);
        }
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMaxSize(int maxSize) {
        if (this.maxSize != maxSize) {
            this.maxSize = maxSize;
            this.fireTransformationsConfigurationModelEvent(GetOrfTransformationConfigurationChangeType.MAXSIZE_CHANGED, this.maxSize);
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setAdditionalParameters(String additionalParameters) {
        if (this.additionalParameters == null || !this.additionalParameters.equals(additionalParameters)) {
            this.additionalParameters = additionalParameters;
            this.fireTransformationsConfigurationModelEvent(GetOrfTransformationConfigurationChangeType.ADDITONAL_PARAMETERS_CHANGED, this.additionalParameters);
        }
    }

    public String getAdditionalParameters() {
        return this.additionalParameters;
    }
}

