/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClusterStateProvider
implements ClusterStateProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String urlScheme;
    volatile Set<String> liveNodes;
    long liveNodesTimestamp = 0L;
    volatile Map<String, List<String>> aliases;
    long aliasesTimestamp = 0L;
    private int cacheTimeout = 5;
    final HttpClient httpClient;
    final boolean clientIsInternal;

    public HttpClusterStateProvider(List<String> solrUrls, HttpClient httpClient) throws Exception {
        this.httpClient = httpClient == null ? HttpClientUtil.createClient(null) : httpClient;
        this.clientIsInternal = httpClient == null;
        for (String solrUrl : solrUrls) {
            this.urlScheme = solrUrl.startsWith("https") ? "https" : "http";
            try (HttpSolrClient initialClient = ((HttpSolrClient.Builder)new HttpSolrClient.Builder().withBaseSolrUrl(solrUrl).withHttpClient(httpClient)).build();){
                Set<String> liveNodes = HttpClusterStateProvider.fetchLiveNodes(initialClient);
                this.liveNodes = liveNodes;
                this.liveNodesTimestamp = System.nanoTime();
                break;
            }
            catch (IOException e) {
                log.warn("Attempt to fetch live_nodes from " + solrUrl + " failed.", (Throwable)e);
            }
        }
        if (this.liveNodes == null || this.liveNodes.isEmpty()) {
            throw new RuntimeException("Tried fetching live_nodes using Solr URLs provided, i.e. " + solrUrls + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.clientIsInternal && this.httpClient != null) {
            HttpClientUtil.close(this.httpClient);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClusterState.CollectionRef getState(String collection) {
        Iterator<String> iterator = this.liveNodes.iterator();
        while (iterator.hasNext()) {
            String nodeName = iterator.next();
            try (HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder().withBaseSolrUrl(ZkStateReader.getBaseUrlForNodeName(nodeName, this.urlScheme)).withHttpClient(this.httpClient)).build();){
                ClusterState cs = this.fetchClusterState(client, collection, null);
                ClusterState.CollectionRef collectionRef = cs.getCollectionRef(collection);
                return collectionRef;
            }
            catch (IOException | SolrServerException | HttpSolrClient.RemoteSolrException e) {
                if (e.getMessage().contains(collection + " not found")) {
                    this.getAliases(true);
                    return null;
                }
                log.warn("Attempt to fetch cluster state from " + ZkStateReader.getBaseUrlForNodeName(nodeName, this.urlScheme) + " failed.", (Throwable)e);
            }
        }
        throw new RuntimeException("Tried fetching cluster state using the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
    }

    private ClusterState fetchClusterState(SolrClient client, String collection, Map<String, Object> clusterProperties) throws SolrServerException, IOException {
        Map properties;
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (collection != null) {
            params.set("collection", collection);
        }
        params.set("action", "CLUSTERSTATUS");
        QueryRequest request = new QueryRequest(params);
        request.setPath("/admin/collections");
        SimpleOrderedMap cluster = (SimpleOrderedMap)client.request(request).get("cluster");
        Map<String, Object> collectionsMap = collection != null ? Collections.singletonMap(collection, ((NamedList)cluster.get("collections")).get(collection)) : ((NamedList)cluster.get("collections")).asMap(10);
        int znodeVersion = collection != null ? (Integer)((Map)collectionsMap.get(collection)).get("znodeVersion") : -1;
        HashSet<String> liveNodes = new HashSet<String>((List)cluster.get("live_nodes"));
        this.liveNodes = liveNodes;
        this.liveNodesTimestamp = System.nanoTime();
        ClusterState cs = ClusterState.load((Integer)znodeVersion, collectionsMap, liveNodes, "/clusterstate.json");
        if (clusterProperties != null && (properties = (Map)cluster.get("properties")) != null) {
            clusterProperties.putAll(properties);
        }
        return cs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getLiveNodes() {
        if (this.liveNodes == null) {
            throw new RuntimeException("We don't know of any live_nodes to fetch the latest live_nodes information from. If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
        }
        if (TimeUnit.SECONDS.convert(System.nanoTime() - this.liveNodesTimestamp, TimeUnit.NANOSECONDS) <= (long)this.getCacheTimeout()) return this.liveNodes;
        Iterator<String> iterator = this.liveNodes.iterator();
        while (iterator.hasNext()) {
            String nodeName = iterator.next();
            try (HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder().withBaseSolrUrl(ZkStateReader.getBaseUrlForNodeName(nodeName, this.urlScheme)).withHttpClient(this.httpClient)).build();){
                Set<String> liveNodes = HttpClusterStateProvider.fetchLiveNodes(client);
                this.liveNodes = liveNodes;
                this.liveNodesTimestamp = System.nanoTime();
                Set<String> set = liveNodes;
                return set;
            }
            catch (Exception e) {
                log.warn("Attempt to fetch live_nodes from " + ZkStateReader.getBaseUrlForNodeName(nodeName, this.urlScheme) + " failed.", (Throwable)e);
            }
        }
        throw new RuntimeException("Tried fetching live_nodes using all the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
    }

    private static Set<String> fetchLiveNodes(SolrClient client) throws Exception {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", "CLUSTERSTATUS");
        QueryRequest request = new QueryRequest(params);
        request.setPath("/admin/collections");
        SimpleOrderedMap cluster = (SimpleOrderedMap)client.request(request).get("cluster");
        HashSet<String> liveNodes = new HashSet<String>((List)cluster.get("live_nodes"));
        return liveNodes;
    }

    @Override
    public List<String> resolveAlias(String aliasName) {
        return Aliases.resolveAliasesGivenAliasMap(this.getAliases(false), aliasName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<String>> getAliases(boolean forceFetch) {
        if (this.liveNodes == null) {
            throw new RuntimeException("We don't know of any live_nodes to fetch the latest aliases information from. If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
        }
        if (!forceFetch && this.aliases != null) {
            if (TimeUnit.SECONDS.convert(System.nanoTime() - this.aliasesTimestamp, TimeUnit.NANOSECONDS) <= (long)this.getCacheTimeout()) return Collections.unmodifiableMap(this.aliases);
        }
        Iterator<String> iterator = this.liveNodes.iterator();
        while (iterator.hasNext()) {
            String nodeName = iterator.next();
            try (HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder().withBaseSolrUrl(ZkStateReader.getBaseUrlForNodeName(nodeName, this.urlScheme)).withHttpClient(this.httpClient)).build();){
                Map<String, List<String>> aliases = ((CollectionAdminResponse)new CollectionAdminRequest.ListAliases().process(client)).getAliasesAsLists();
                this.aliases = aliases;
                this.aliasesTimestamp = System.nanoTime();
                Map<String, List<String>> map = Collections.unmodifiableMap(this.aliases);
                return map;
            }
            catch (IOException | SolrServerException | HttpSolrClient.RemoteSolrException e) {
                if (e instanceof HttpSolrClient.RemoteSolrException && ((HttpSolrClient.RemoteSolrException)e).code() == 400) {
                    log.warn("LISTALIASES not found, possibly using older Solr server. Aliases won't work unless you re-create the CloudSolrClient using zkHost(s) or upgrade Solr server", (Throwable)e);
                    this.aliases = Collections.emptyMap();
                    this.aliasesTimestamp = System.nanoTime();
                    return this.aliases;
                }
                log.warn("Attempt to fetch cluster state from " + ZkStateReader.getBaseUrlForNodeName(nodeName, this.urlScheme) + " failed.", (Throwable)e);
            }
        }
        throw new RuntimeException("Tried fetching aliases using all the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using a working solrUrl or zkHost.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClusterState getClusterState() throws IOException {
        Iterator<String> iterator = this.liveNodes.iterator();
        while (iterator.hasNext()) {
            String nodeName = iterator.next();
            try (HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder().withBaseSolrUrl(ZkStateReader.getBaseUrlForNodeName(nodeName, this.urlScheme)).withHttpClient(this.httpClient)).build();){
                ClusterState cs;
                ClusterState clusterState = cs = this.fetchClusterState(client, null, null);
                return clusterState;
            }
            catch (IOException | SolrServerException | HttpSolrClient.RemoteSolrException e) {
                log.warn("Attempt to fetch cluster state from " + ZkStateReader.getBaseUrlForNodeName(nodeName, this.urlScheme) + " failed.", (Throwable)e);
            }
        }
        throw new RuntimeException("Tried fetching cluster state using the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> getClusterProperties() {
        Iterator<String> iterator = this.liveNodes.iterator();
        while (iterator.hasNext()) {
            String nodeName = iterator.next();
            try (HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder().withBaseSolrUrl(ZkStateReader.getBaseUrlForNodeName(nodeName, this.urlScheme)).withHttpClient(this.httpClient)).build();){
                HashMap<String, Object> clusterProperties = new HashMap<String, Object>();
                this.fetchClusterState(client, null, clusterProperties);
                HashMap<String, Object> hashMap = clusterProperties;
                return hashMap;
            }
            catch (IOException | SolrServerException | HttpSolrClient.RemoteSolrException e) {
                log.warn("Attempt to fetch cluster state from " + ZkStateReader.getBaseUrlForNodeName(nodeName, this.urlScheme) + " failed.", (Throwable)e);
            }
        }
        throw new RuntimeException("Tried fetching cluster state using the node names we knew of, i.e. " + this.liveNodes + ". However, succeeded in obtaining the cluster state from none of them.If you think your Solr cluster is up and is accessible, you could try re-creating a new CloudSolrClient using working solrUrl(s) or zkHost(s).");
    }

    @Override
    public String getPolicyNameByCollection(String coll) {
        throw new UnsupportedOperationException("Fetching cluster properties not supported using the HttpClusterStateProvider. ZkClientClusterStateProvider can be used for this.");
    }

    public Object getClusterProperty(String propertyName) {
        if (propertyName.equals("urlScheme")) {
            return this.urlScheme;
        }
        return this.getClusterProperties().get(propertyName);
    }

    @Override
    public void connect() {
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(int cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }
}

