/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.yacli.command;

import es.uvigo.ei.sing.yacli.command.Command;
import es.uvigo.ei.sing.yacli.command.CommandPrinterConfiguration;
import es.uvigo.ei.sing.yacli.command.option.DefaultValuedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.OptionCategory;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CommandPrinter {
    public static void printCommandOptionsExtended(Command command, PrintStream out, CommandPrinterConfiguration configuration) {
        HashMap<OptionCategory, List> optionsByCategory = new HashMap<OptionCategory, List>();
        command.getOptions().forEach(option -> option.getCategories().forEach(category -> {
            if (!optionsByCategory.containsKey(category)) {
                optionsByCategory.put((OptionCategory)category, new LinkedList());
            }
            ((List)optionsByCategory.get(category)).add(option);
        }));
        if (optionsByCategory.keySet().size() == 1 && optionsByCategory.keySet().contains(OptionCategory.DEFAULT_CATEGORY)) {
            for (Option<?> option2 : command.getOptions()) {
                CommandPrinter.printOption(option2, out, configuration);
            }
        } else {
            if (optionsByCategory.containsKey(OptionCategory.DEFAULT_CATEGORY)) {
                out.print("\t");
                out.println(configuration.getUngroupedOptionsMessage());
                for (Option option3 : (List)optionsByCategory.get(OptionCategory.DEFAULT_CATEGORY)) {
                    CommandPrinter.printOption(option3, out, configuration);
                }
                out.println();
            }
            optionsByCategory.remove(OptionCategory.DEFAULT_CATEGORY);
            optionsByCategory.forEach((category, options) -> {
                if (configuration.isPrintCategoryName()) {
                    out.println("\t" + category.getName() + ":");
                }
                for (Option option : options) {
                    CommandPrinter.printOption(option, out, configuration);
                }
                out.println();
            });
        }
    }

    protected static void printOption(Option<?> option, PrintStream out, CommandPrinterConfiguration configuration) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t--").append(option.getParamName()).append("/-").append(option.getShortName());
        if (option.requiresValue()) {
            sb.append(" <").append(option.getParamName()).append(">");
        }
        sb.append("\n");
        StringBuilder optionDescription = new StringBuilder(option.getDescription());
        if (option instanceof DefaultValuedOption) {
            optionDescription.append(" (default: ").append(((DefaultValuedOption)option).getDefaultValue()).append(")");
        }
        if (option.isMultiple()) {
            optionDescription.append(configuration.getMultipleParameterString());
        }
        if (configuration.getBreakLines() == 0) {
            sb.append("\t\t").append(optionDescription.toString());
        } else {
            sb.append(CommandPrinter.breakDescription(optionDescription.toString(), configuration.getBreakLines(), "\t\t"));
        }
        out.println(sb.toString());
    }

    protected static String breakDescription(String description, int breakLines, String indent) {
        if (description.contains("\n")) {
            String[] descriptionSplit = description.split("\n");
            StringBuilder toret = new StringBuilder();
            for (int i = 0; i < descriptionSplit.length; ++i) {
                String line = descriptionSplit[i];
                int firstNonTabCharIndex = CommandPrinter.findFirstNonTabCharIndex(line);
                String newIndent = indent + IntStream.range(0, firstNonTabCharIndex).mapToObj(x -> "\t").collect(Collectors.joining());
                toret.append(CommandPrinter.breakDescription(line.substring(firstNonTabCharIndex), breakLines, newIndent));
                if (i >= descriptionSplit.length - 1) continue;
                toret.append("\n");
            }
            return toret.toString();
        }
        String[] wordSplit = description.split(" ");
        StringBuilder currentLine = new StringBuilder(indent);
        ArrayList<String> toret = new ArrayList<String>();
        for (String word : wordSplit) {
            if (currentLine.length() + word.length() + 1 <= breakLines) {
                if (currentLine.length() > indent.length()) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            toret.add(currentLine.toString());
            currentLine = new StringBuilder(indent);
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            toret.add(currentLine.toString());
        }
        return toret.stream().collect(Collectors.joining("\n"));
    }

    protected static int findFirstNonTabCharIndex(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\t') continue;
            return i;
        }
        return 0;
    }
}

