/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import es.uvigo.ei.sing.commons.csv.entities.CsvData;
import es.uvigo.ei.sing.commons.csv.entities.CsvEntry;
import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import es.uvigo.ei.sing.commons.csv.io.CsvWriter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sing_group.seda.core.filtering.HeaderMatcher;
import org.sing_group.seda.core.operations.SequenceIsoformSelector;
import org.sing_group.seda.core.operations.SequencesGroupIsoformTester;
import org.sing_group.seda.core.operations.SequencesGroupIsoformTesterResult;
import org.sing_group.seda.core.operations.SequencesGroupSeparator;
import org.sing_group.seda.core.rename.SequenceHeadersJoiner;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.sequencesgroup.SequencesGroupTransformation;

public class RemoveIsoformsSequencesGroupTransformation
implements SequencesGroupTransformation {
    private static final CsvEntry CSV_HEADER = new CsvEntry(Arrays.asList("Selected isoform", "Removed isoforms"));
    private static final CsvFormat CSV_FORMAT = new CsvFormat("\t", '.', true, System.lineSeparator());
    private DatatypeFactory factory;
    private HeaderMatcher matcher;
    private RemoveIsoformsTransformationConfiguration configuration;
    private SequenceIsoformSelector isoformSelector;
    private SequenceHeadersJoiner sequenceHeadersJoiner;

    public RemoveIsoformsSequencesGroupTransformation(RemoveIsoformsTransformationConfiguration configuration, SequenceIsoformSelector isoformSelector, SequenceHeadersJoiner sequenceHeadersJoiner) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), configuration, isoformSelector, sequenceHeadersJoiner);
    }

    public RemoveIsoformsSequencesGroupTransformation(HeaderMatcher matcher, RemoveIsoformsTransformationConfiguration configuration, SequenceIsoformSelector isoformSelector, SequenceHeadersJoiner sequenceHeadersJoiner) {
        this(DatatypeFactory.getDefaultDatatypeFactory(), matcher, configuration, isoformSelector, sequenceHeadersJoiner);
    }

    public RemoveIsoformsSequencesGroupTransformation(DatatypeFactory factory, RemoveIsoformsTransformationConfiguration configuration, SequenceIsoformSelector isoformSelector, SequenceHeadersJoiner sequenceHeadersJoiner) {
        this(factory, null, configuration, isoformSelector, sequenceHeadersJoiner);
    }

    public RemoveIsoformsSequencesGroupTransformation(DatatypeFactory factory, HeaderMatcher matcher, RemoveIsoformsTransformationConfiguration configuration, SequenceIsoformSelector isoformSelector, SequenceHeadersJoiner sequenceHeadersJoiner) {
        this.factory = factory;
        this.matcher = matcher;
        this.configuration = configuration;
        this.isoformSelector = isoformSelector;
        this.sequenceHeadersJoiner = sequenceHeadersJoiner;
    }

    @Override
    public SequencesGroup transform(SequencesGroup sequencesGroup) throws TransformationException {
        SequencesGroupIsoformTesterResult isoformsResult = new SequencesGroupIsoformTesterResult();
        int minimumIsoformWordLength = this.configuration.getMinimumIsoformWordLength();
        if (this.matcher == null) {
            new SequencesGroupIsoformTester(sequencesGroup).test(minimumIsoformWordLength).getIsoformsLists().forEach(l -> isoformsResult.addIsoformsList((List<Sequence>)l));
        } else {
            Map<String, List<Sequence>> groups = new SequencesGroupSeparator(this.matcher).separate(sequencesGroup);
            groups.forEach((k, v) -> {
                SequencesGroup current = this.factory.newSequencesGroup((String)k, sequencesGroup.getProperties(), (List<Sequence>)v);
                new SequencesGroupIsoformTester(current).test(minimumIsoformWordLength).getIsoformsLists().forEach(l -> isoformsResult.addIsoformsList((List<Sequence>)l));
            });
        }
        LinkedList csvEntries = new LinkedList();
        LinkedList<Sequence> sequences = new LinkedList<Sequence>();
        isoformsResult.getIsoformsLists().forEach(l -> {
            Sequence selectedSequence = this.isoformSelector.selectSequence((List<Sequence>)l);
            if (this.configuration.isSaveRemovedIsoformsFile() && l.size() > 1) {
                csvEntries.add(this.csvEntry((List<Sequence>)l, selectedSequence));
            }
            String newDescripion = selectedSequence.getDescription() + " " + (l.size() > 1 ? this.sequenceHeadersJoiner.join(l.stream().filter(f -> !f.equals(selectedSequence)).collect(Collectors.toList())) : "");
            sequences.add(this.factory.newSequence(selectedSequence.getName(), newDescripion.trim(), selectedSequence.getChain(), selectedSequence.getProperties()));
        });
        if (this.configuration.isSaveRemovedIsoformsFile() && !csvEntries.isEmpty()) {
            try {
                this.configuration.getRemovedIsoformsFileDirectory().mkdirs();
                CsvWriter.of((CsvFormat)CSV_FORMAT).write(CsvData.CsvDataBuilder.newCsvDataBuilder((CsvFormat)CSV_FORMAT).withHeader(CSV_HEADER).withEntries(csvEntries).build(), new File(this.configuration.getRemovedIsoformsFileDirectory(), sequencesGroup.getName() + ".csv"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.factory.newSequencesGroup(sequencesGroup.getName(), sequencesGroup.getProperties(), sequences);
    }

    private CsvEntry csvEntry(List<Sequence> l, Sequence selectedSequence) {
        return new CsvEntry(Arrays.asList(selectedSequence.getName(), l.stream().filter(f -> !f.equals(selectedSequence)).map(Sequence::getName).collect(Collectors.joining(", "))));
    }

    public static class RemoveIsoformsTransformationConfiguration {
        private int minimumIsoformWordLength;
        private File removedIsoformsFileDirectory;

        public RemoveIsoformsTransformationConfiguration(int minimumIsoformWordLength) {
            this(minimumIsoformWordLength, null);
        }

        public RemoveIsoformsTransformationConfiguration(int minimumIsoformWordLength, File removedIsoformsFileDirectory) {
            this.minimumIsoformWordLength = minimumIsoformWordLength;
            this.removedIsoformsFileDirectory = removedIsoformsFileDirectory;
        }

        public int getMinimumIsoformWordLength() {
            return this.minimumIsoformWordLength;
        }

        public boolean isSaveRemovedIsoformsFile() {
            return this.removedIsoformsFileDirectory != null;
        }

        public File getRemovedIsoformsFileDirectory() {
            return this.removedIsoformsFileDirectory;
        }
    }
}

